void plot_dist(double ra, double dec, double rad) 
{
    //
    //
    //
    gROOT->SetStyle("Plain");     // ɽ off
    gStyle->SetOptTitle(kFALSE);  // ȥä
    gStyle->SetOptStat(kFALSE);   // ׾ä

    TCanvas* c1 = new TCanvas("c1", "c1", 400, 800);
    c1->Divide(1,2);

    c1->cd(1);
    plot_objects(ra, dec, rad);


    c1->cd(2);
    plot_density();
}


/**
 *
 */
void plot_objects(double ra, double dec, double rad)
{
    //
    // 
    //
    Double_t x, y;
    double xmin, xmin, ymin, ymax;
    double dy, dx;

    string buf;
    TNtuple* nt = new TNtuple("object", "object", "x:y");

    
    dx = rad / cos(dec/180.*3.141592654);
    dy = rad;
    //printf("dx=%f dy=%f\n PI=%f", dx, dy);
    xmin = ra - dx;
    xmax = ra + dx;
    ymin = dec - dy;
    ymax = dec + dy;

    //
    // ǡ
    //
    ifstream data("radec.dat");
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>x>>y; 
        nt->Fill(x, y);
    }
    data.close();

    gStyle->SetNdivisions(505, "X");
    gStyle->SetNdivisions(505, "Y");


    //
    // XY ɽϰϤꤹ뤿ζҥȥ
    //
    printf("%f %f %f %f\n", xmin, xmax, ymin, ymax);

    TH1F *waku = new TH1F("waku", "title", 2, xmin, xmax);
    waku->SetMinimum(ymin);
    waku->SetMaximum(ymax);
    waku->Draw();
    waku->GetXaxis()->SetTitle("RA");
    waku->GetYaxis()->SetTitle("Dec");

    TEllipse *region = new TEllipse(ra, dec, dx, dy);
    region->Draw("same");
    //
    // ץå
    //
    nt->SetMarkerStyle(20);       // ޡ
    nt->SetMarkerColor(2);        // ޡο
    nt->SetMarkerSize(0.4);       // ޡ
    nt->Draw("y:x", "", "same");


}

/**
 *
 */
void plot_density()
{
    double x[1000], y[1000], sig[1000], erx[1000];
    double dummy;
    ifstream data("density.dat");
    int ind=0;
    string buf;
    //
    //
    //
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>x[ind]>>dummy>>dummy>>dummy>>y[ind]>>sig[ind]; 
        erx[ind] = 0;
        ind++;
        if(ind >= 1000) {
            break;
        }
    }
    data.close();
    //
    //
    //
//  TF1 *func = new TF1("func", func_cc, 0.01, 3, 2);

//    func->SetParLimits(0, 1, 120.0);
//    func->SetParLimits(1, 5.0, 10.0);
//    func->SetLineColor(1);
//    func->SetLineWidth(1);
//
//  func->SetParameters(10.0, 0.0);
//  func->Draw();
//


    graph = new TGraphErrors(29, x, y, erx, sig);
//  graph->Fit(func, "", "", 0.0, 3.0);

    graph->SetLineColor(1);
    graph->SetLineWidth(1);
    graph->SetMarkerColor(1);
    graph->SetMarkerSize(1.);
    graph->SetMarkerStyle(20);

    graph->SetTitle("");
    graph->GetXaxis()->SetTitle("distance (Mpc)");
    graph->GetYaxis()->SetTitle("density (Mpc-3)");

    graph->Draw("AP");
    
}
