#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "opt.h"
#include "spline.h"
#include "astro-lib.h"

#include "lf.h"


double g_mlimit;
double g_mmin = 10.;
double g_redshift;
double g_wavelength = -1;
char *g_band = NULL;

/**
 *
 */
int main(int argc, char *argv[])
{
    double rho, dm, mlimit, wl, mmin;
    double alpha, m0;
			     
    optUsage("[OPTIONS]");
    optrega(&g_mlimit, OPT_DOUBLE, 'm', "mlimit", "limiting magnitude");
    optrega(&g_mmin, OPT_DOUBLE, '\0', "m-min", "minimum magnitude");
    optrega(&g_band, OPT_VSTRING, 'b', "band", "band name (B|V|R|I|i|z|K)");
    optrega(&g_wavelength, OPT_DOUBLE, 'w', "wavelength", "wavelength in observer frame [A]");
    optrega(&g_redshift, OPT_DOUBLE, 'z', "redshift", "redshift");
    opt(&argc, &argv);

    //
    //
    //
    dm = get_distance_modulus(Z, g_redshift);
    printf("# distance modulus = %lf\n", dm);
    
    mlimit = g_mlimit - dm;
    mmin = g_mmin - dm;

    if(g_band != NULL) {
	if(strcmp(g_band, "B") == 0) {
	    wl = 4420 / (1 + g_redshift);
	    printf("# B band  4420\n");
	} else if(strcmp(g_band, "V") == 0) {
	    wl = 5500 / (1 + g_redshift);
	    printf("# V band  5500\n");
	} else if(strcmp(g_band, "R") == 0) {
	    wl = 6500 / (1 + g_redshift);
	    printf("# R band  6500\n");
	} else if(strcmp(g_band, "I") == 0) {
	    wl = 8000 / (1 + g_redshift);
	    printf("# I band  8000\n");
	} else if(strcmp(g_band, "i") == 0) {
	    wl = 7700 / (1 + g_redshift);
	    printf("# i band  7700\n");
	} else if(strcmp(g_band, "z") == 0) {
	    wl = 9100 / (1 + g_redshift);
	    printf("# z band  9100\n");
	} else if(strcmp(g_band, "K") == 0) {
	    wl = 22000 / (1 + g_redshift);
	    printf("# K band  22000\n");
	} else {
	    fprintf(stderr, "invalid band name %s\n", g_band);
	    exit(1);
	}
    } else if(g_wavelength > 0) {
	wl = g_wavelength / (1 + g_redshift);
	printf("# Wavelength (obs) %lf\n", g_wavelength);
    } else {
	fprintf(stderr, "invalid band name %s\n", g_band);
	fprintf(stderr, "invalid wavelength (obs) %lf\n", g_wavelength);
	exit(1);
    }


    //
    //
    //
    alpha = get_param_alpha(g_redshift, wl);
    m0 = get_param_M0(g_redshift, wl);

    printf("# wavelength at source: %lf\n", wl);
    printf("# M0: %lf\n", m0);
    printf("# alpha: %lf\n", alpha);
    
    rho = integ(g_redshift, wl, mmin, mlimit);
    printf("rho= %le\n", rho);

    exit(0);
}

