#!/bin/sh -f
#
#  $BJQ?tL>$O(B c_  $B$G;O$^$k(B
#  $B4X?tL>$O(B c__ $B$G;O$^$k(B
#


#
# $B6&DLJQ?t(B
#
c_script=${0##/*/}
c_name=${c_script%.*}
c_tag=`date +%y%m%d_%H%M%S`_$(hostname -s)
c_procid=
c_tdir=$(pwd)
c_jobid=0
c_wdir=
c_log=
c_elog=
c_stdout=
c_status=
c_prefix=${HOME}/grid_engine
c_app_name=grid
c_prop0=
c_prop1=
c_script="${0##*/}"
c_argv="$@"
c_java=
c_hid=
c_ramdir=/dev/shm/${USER}


# echo "# c_prefix=$c_prefix"

#
# IRAF $B%Q%i%a!<%?%G%#%l%/%H%j$H(B ftools $B$N%Q%i%a!<%?%G%#%l%/%H%j(B
#
c_pfile=${c_prefix}/var/pfiles/pfiles.$$
c_uparm=${c_prefix}/var/pfiles/uparm.$$
mkdir -p ${c_pfile}
mkdir -p ${c_uparm}
#export PFILES="${c_pfile};${HEADAS}/syspfiles"

#
# job id $B$r(B $B?F%G%#%l%/%H%jL>$+$i7hDj(B
#
c_jobid=$(pwd | awk -F/ '{print $(NF-1)}' | grep "[0-9]\{6\}_[0-9]\{6\}_.\+_[0-9]\+" | awk -F_ '{if(NF==4) printf("%03d", $NF)}')
if [ "$c_jobid" == "" ]; then
   c_jobid=$(pwd | awk -F/ '{print $(NF)}' | grep "[0-9]\{6\}_[0-9]\{6\}_.\+_[0-9]\+" | awk -F_ '{if(NF==4) printf("%03d", $NF)}')
   if [ "$c_jobid" == "" ]; then
      c_jobid=999
   fi
fi
c_procid=${c_tag}_${c_jobid}


#
# echo "# pwd=$(pwd)"
# echo "# c_jobid=$c_jobid"
#
#
#
# echo "# GRID_HOME=$GRID_HOME"
if [ -n "$GRID_HOME" ]; then
    c_prefix=${GRID_HOME}
fi

# echo "# c_prefix=$c_prefix"

if [ -n "$APP_NAME" ]; then
    c_app_name=${APP_NAME}
fi

c_prop0=${JVO_DEV}/conf/${c_app_name}/jvo.properties
c_prop1=${c_prefix}/etc/jvo.properties
c_java="${JAVA_HOME}/bin/java -Djvo.default.properties=${c_prop0} -Djvo.properties=${c_prop1} -Djava.awt.headless=true"
# echo "# c_prop0=$c_prop0"
# echo "# c_prop1=$c_prop1"

export LANG=C


#
# $B%9%/%j%W%H3+;O%a%C%;!<%8(B
#
function c__script_start
{
   c__init_log

   local d=$(date '+%Y-%m-%dT%H:%M:%S')
   c__log F:$FUNCNAME $LINENO "============================= ${c_script} start"
   c__log F:$FUNCNAME $LINENO "$d" 
   c__log F:$FUNCNAME $LINENO "${c_script} ${c_argv}"

}

#
# $B%9%/%j%W%H=*N;%a%C%;!<%8(B  script [message]
#
function c__script_end
{
   local d=$(date '+%Y-%m-%dT%H:%M:%S')
   c__log F:$FUNCNAME $LINENO  "$d"
   c__log F:$FUNCNAME $LINENO "============================= ${c_script} end"
}


#
#
#
function c__mark_start
{
   local d=$(date '+%Y-%m-%dT%H:%M:%S')

   if [ ! -s .start ]; then
      echo "$d"  > .start
   fi

   if [ ! -s .command ]; then
      echo "$c_script $c_argv" > .command
      echo "$d $c_script $c_argv" > .history
   else
      echo "$d $c_script $c_argv" >> .history
   fi   
}

#
#
#
function c__mark_end
{
   local d=$(date '+%Y-%m-%dT%H:%M:%S')

   if [ ! -s .end ]; then
      echo "$d"  > .end
   else
      echo "$d"  > .end
   fi
}


#
#
#
function c__stdout 
{
   set -o noglob
   while read; do
      if echo "$REPLY" | grep "^#" > /dev/null; then
         echo $REPLY 
      else
         echo "# $1: $REPLY" 
      fi
   done
   set +o noglob
}

#
# $B%o!<%/%G%#%l%/%H%j(B $wdir $B$r:n@.(B
#
function c__create_wdir
{
   ### $B%o!<%/%G%#%l%/%H%j$N7hDj(B
   if [ -z "${c_wdir}" ]; then
      c_wdir=${c_name}_${c_tag}
   fi

   #
   # $BB8:_$7$J$$>l9g:n@.(B
   # 
   if [ ! -d "${c_wdir}" ]; then
      mkdir -p  $c_wdir
   fi

   #
   #
   #
   c__init_log

}


#
#
#
function c__init_pfile
{
    c_pfile=${c_prefix}/var/pfiles/pfiles.$$
    mkdir -p ${c_pfile}
    export PFILES="${c_pfile};${HEADAS}/syspfiles"
}

#
#
#
function c__init_log 
{
   if [ -z "${c_wdir}" ]; then
      c_wdir=.
   fi

   #
   # $B@dBP%Q%9$+!)(B
   #
   if echo $c_wdir | grep ^/ > /dev/null; then
      c_log=${c_wdir}/${c_name}.log
      c_elog=${c_wdir}/${c_name}.err
      c_stdout=${c_wdir}/${c_name}.stdout
      c_status=${c_wdir}/${c_name}.stat
   else   
      c_log=${c_tdir}/${c_wdir}/${c_name}.log
      c_elog=${c_tdir}/${c_wdir}/${c_name}.err
      c_stdout=${c_tdir}/${c_wdir}/${c_name}.stdout
      c_status=${c_tdir}/${c_wdir}/${c_name}.stat
   fi

   if ! echo $c_java | grep "Dtmp.dir=" > /dev/null; then
      local dir=${c_log%/*}
      c_java="${c_java} -Dtmp.dir=${dir}/tmp"
      echo "# c_java=${c_java}"
   fi
}


#
# $B%o!<%/%G%#%l%/%H%jFb$K;XDj$7$?%Q%9$X$N%7%s%\%j%C%/%U%!%$%k$r(B
# $B:n@.$7!"$=$N%U%!%$%kL>$rJV$9!#(B
#
function c__symlink_to_workdir {
  local fn=$1

  if [ -e "${c_wdir}/${fn##*/}" ]; then
     c__log F:$FUNCNAME $LINENO "$fn already linked"
  else
    if echo $fn | grep ^/ > /dev/null; then
        ln -s ${fn} ${c_wdir}
    else   
        ln -s ${c_tdir}/${fn} ${c_wdir}
    fi
  fi

  return 0
}

#
#
#
function c__copy_to_workdir {
  local fn=$1
  cp -p ${fn} ${c_wdir}
  return 0
}

#
# $B%9%?!<$H%a%C%;!<%8$r%9%F!<%?%9%U%!%$%k$K=q$/(B
#
function c__status_start
{
   echo "START: `date '+%Y-%m-%dT%H:%M:%S'`" > ${c_status}
   echo "PID: $$"  >> ${c_status}
   echo "STATUS: RUNNING" >> ${c_status}
}

#
# $B=*N;%a%C%;!<%8$r%9%F!<%?%9%U%!%$%k$K=q$/(B
#
function c__status_end
{
   cat ${c_status} | grep -v "STATUS:" > status.$$.dat
   echo "STATUS: FINISHED" >> status.$$.dat
   echo "STOP: `date '+%Y-%m-%dT%H:%M:%S'`" >> status.$$.dat
   /bin/cp status.$$.dat ${c_status}
   /bin/rm -f status.$$.dat
}

#
# $B%m%0%a%C%;!<%8(B
#
function c__log
{
   local arg=$(echo "$@" | awk '{
      gsub("^F:", script":"); 
      gsub("^MAIN", script":MAIN "); 
      print $0;
   }' script=$c_script)

   local timestamp=$(date +%y%m%d_%H%M%S)
   set -o noglob
   echo $timestamp $c_script $@ >> $c_log
   echo [$timestamp] "$arg"
   set +o noglob

}

#
# $B%(%i!<%a%C%;!<%8(B
#
function c__error
{

   set -o noglob

   #
   # $B%8%g%V0[>o=*N;%9%F!<%?%9$N@_Dj(B
   #
   touch ${c_status}
#  echo "touch ${c_status}"
   cat ${c_status} | grep -v "STATUS:" > status.$$.dat
   echo "STATUS: ERROR" >> status.$$.dat
   echo "STOP: `date '+%Y-%m-%dT%H:%M:%S'`" >> status.$$.dat
   echo "ERROR: $@" >> status.$$.dat

   /bin/cp status.$$.dat ${c_status}
   /bin/rm -f status.$$.dat

   local timestamp=$(date +%y%m%d_%H%M%S)
   echo  "[$timestamp] $@" >> $c_elog

   local arg=$(echo "$@" | awk '{
      gsub("^F:", script":"); 
      gsub("^MAIN", script); 
      print $0;
   }' script=$c_script)

#  c__log "*** error : $@"
   echo $timestamp $c_script $@ >> $c_log
   echo [$timestamp] "*** error : $arg"

   c__mark_end
   c__script_end

   set +o noglob

   exit 1
}

#
#
#
function c__set_hostid {
    local host=$(hostname -s)
    c_hid=$(nslookup ${host} | grep Address | tail -1 | awk -F. '{print $NF}')
}


#
# c__get_property <name>
#
function c__get_property {
   value1=$(cat ${prop1} | grep "$1" | awk -F= '{
       gsub("^ +", "", $1); gsub(" +$", "", $1); 
       gsub("^ +", "", $2); gsub(" +$", "", $2); 
       if($1==key) {print $2}
   }' key=$1 | tail -1)

   if [ "$value1" != "" ]; then
      echo $value1
      return 0
   fi

   value0=$(cat ${prop0} | grep "$1" | awk -F= '{
       gsub("^ +", "", $1); gsub(" +$", "", $1); 
       gsub("^ +", "", $2); gsub(" +$", "", $2); 
       if($1==key) {print $2}
   }' key=$1 | tail -1)
   
   if [ "$value0" == "" ]; then
      echo ""
      return 1
   else
      echo $value0
      return
   fi
}

function c__clean
{
   /bin/rm -rf _*.$$.*
   /bin/rm -rf .*.$$.*
   /bin/rm -rf ${c_pfile}
   /bin/rm -rf ${c_uparm}
   /bin/rm -rf ${c_ramdir}/.*.$$.*
}

