#define SCALAR double
typedef SCALAR *vector;
typedef SCALAR **matrix;

#define NX_PSF 101                        /* This should be an odd value */
#define NY_PSF 101                        /* This should be an odd value */
#define FINE_FACTOR 5                    /* pix resolution of psf is 10 times
                                            finer than a real image */
#define NX_PSF_FINE (FINE_FACTOR*NX_PSF) /* number of x-pix of psf */
#define NY_PSF_FINE (FINE_FACTOR*NY_PSF) /* number of y-pix of psf */

typedef struct s_image {
  int nx;
  int ny;
  matrix image;
  matrix err;
} Image;


matrix newmat(int nrow, int ncol);
void   normalize_image(Image *image);
void   free_matrix(matrix a);
void   init_image(int nx, int ny, Image *image);
void   free_image(Image *a);
void   clear_image(Image *a);
