#ifndef SCALAR
#define SCALAR double
#endif
typedef SCALAR *vector, **matrix;

 void error(char *message);
 vector newvec(int n);
 matrix newmat(int nrow, int ncol);
 vector new_vector(int n);
 matrix new_matrix(int nrow, int ncol);
 void free_vector(vector v);
 void free_matrix(matrix a);
 double innerproduct(int n, vector u, vector v);
 void vecprint(vector v, int n, int perline, char *format);
 int matprint(matrix a, int ncol, int perline, char *format);
 void vecinput(FILE *fp, vector v, int n, int perline, char *format);
 int matinput(FILE *fp, matrix a, int ncol, int perline, char *format);
 double lu(int n, matrix a, int *ip);
 double matinv(int n, matrix a, matrix a_inv);
 double matinv0(int n, matrix a);
int lsq(int n, int m, matrix x, vector b, int *col, vector initnormsq, vector normsq);
 void invr(int r, matrix x);
