/***********************************************************
	regress.c -- A
***********************************************************/
//#include "statutil.c"
#include "stdio.h"
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include <string.h>    /* {\tt strchr()} */
#include <limits.h>    /* {\TT INT\_MAX} */
#include "matutil.h"

#define PIVOTING 1    /* s{bgIs */
#define VERBOSE  0    /* ro߂o͂邩 */
#define EPS   1e-6    /* e덷 */

#if ! PIVOTING  /* s{bgIsȂꍇ */


/**
 *
 *  y[i] = b[j] * x[i][j]   (j=1..m)
 *
 *  mat  (m + 1)*n ̍s
 *  
 *
 *  col[0..m-1] ͗ԍ
 *  mat[0..m][0..m-1] ̓f[^
 *  b[0..m-1] ͉AW
 *
 *  normsq[0..m-1] ͊êQa
 *
 *  mat[0..m-1][0..n-1]  X^T
 *  mat[m][0..n-1]  y^T
 *
 *  mat[m][0] = y[0]
 *  mat[m][1] = y[1]
 *  ...
 *
 *  x[0][0] = x[0][0]
 *  x[1][0] = x[0][1]
 *  ...
 *  x[0][1] = x[1][0]
 *  ...
 *
 *  @param n [IN] f[^
 *  @param m [IN] p[^
 *  @param x [IN] x[i] y[i] - a[i]*x[i]
 *  @param b [OUT] tBbeBOp[^
 *  @param col [OUT] ԍێ
 *  @param normsq [OUT] êQa
 */
int lsq(int n, int m, matrix x, vector b, int *col, vector normsq)  /* ŏ2@ */
        
{
	int i, j, k, r;
	double s, t, u;
	vector v, w;

	for (j = 0; j < m; j++)
		normsq[j] = innerproduct(n, x[j], x[j]);
	r = 0;
	for (k = 0; k < m; k++) {
		if (normsq[k] == 0) continue;
		v = x[k];  u = innerproduct(n - r, &v[r], &v[r]);
		#if VERBOSE
			printf("\n%4d: 2a2a = %-14g",
				k + 1, u / normsq[k]);
		#endif
		if (u / normsq[k] < EPS * EPS) continue;
		x[r] = v;  col[r] = k;
		u = sqrt(u);  if (v[r] < 0) u = -u;
		v[r] += u;  t = 1 / (v[r] * u);
		for (j = k + 1; j <= m; j++) {
			w = x[j];
			s = t * innerproduct(n - r, &v[r], &w[r]);
			for (i = r; i < n; i++) w[i] -= s * v[i];
		}
		v[r] = -u;
		#if VERBOSE
			printf("  c2a = %g",
			  innerproduct(n-r-1, &x[m][r+1], &x[m][r+1]));
		#endif
		r++;
	}
	for (j = r - 1; j >= 0; j--) {
		s = x[m][j];
		for (i = j + 1; i < r; i++) s -= x[i][j] * b[i];
		b[j] = s / x[j][j];
	}
	#if VERBOSE
		printf("\n\n");
	#endif
	return r;  /* rank */
}

#else /* s{bgIsꍇ */

#define swap(a, i, j, t)  t = a[i];  a[i] = a[j];  a[j] = t

int lsq(int n, int m, matrix x, vector b, int *col, vector initnormsq, vector normsq)
{
    int i, j, r;
    double s, t, u;
    vector v, w;

    for (j = 0; j < m; j++) {
        col[j] = j;
        normsq[j] = innerproduct(n, x[j], x[j]);
        initnormsq[j] = (normsq[j] != 0) ? normsq[j] : -1;
    }

    //for(i = 0; i < n; i++) {
    //for(j = 0; j <= m; j++) {
    //printf("%le ", x[j][i]);
    //}
    //printf("\n");
    //}


    for (r = 0; r < m; r++) {
        if (r != 0) {
            j = r;  u = 0;
            for (i = r; i < m; i++) {
                t = normsq[i] / initnormsq[i];
                if (t > u) {  u = t;  j = i;  }
            }
            swap(col, j, r, i);
            swap(normsq, j, r, t);
            swap(initnormsq, j, r, t);
            swap(x, j, r, v);
        }

        v = x[r]; 
        u = innerproduct(n - r, &v[r], &v[r]);

        //printf("# u = %le\n", u);
        //printf("# initnromsq[r] = %le\n", initnormsq[r]);

        if (u / initnormsq[r] < EPS * EPS) {
            break;
        }

        u = sqrt(u);  if (v[r] < 0) u = -u;
        v[r] += u;  t = 1 / (v[r] * u);
        for (j = r + 1; j <= m; j++) {
            w = x[j];
            s = t * innerproduct(n - r, &v[r], &w[r]);
            for (i = r; i < n; i++) w[i] -= s * v[i];
            if (j < m) normsq[j] -= w[r] * w[r];
        }
        v[r] = -u;
    }
    for (j = r - 1; j >= 0; j--) {
        s = x[m][j];
        for (i = j + 1; i < r; i++) s -= x[i][j] * b[i];
        b[j] = s / x[j][j];
    }
    return r;  /* rank */
}

#endif /* PIVOTING */

void invr(int r, matrix x)  /* Ops̋ts */
{
	int i, j, k;
	double s;

	for (k = 0; k < r; k++) {
		x[k][k] = 1 / x[k][k];
		for (j = k - 1; j >= 0; j--) {
			s = 0;
			for (i = j + 1; i <= k; i++)
				s -= x[i][j] * x[i][k];
			x[j][k] = s * x[j][j];
		}
	}
}

