#include "qsort2.h"

static void inssort(int n, keytype a[]);
static void inssort_index(int n, keytype a[], int index[]);


void index_sort(int n, keytype a[], int index[]) {

  int i, j, left, right, p;
  int ind, ind_i, ind_j, s;
  int leftstack[STACKSIZE], rightstack[STACKSIZE];

  keytype x, t;
  
  left = 0; right = n - 1; p = 0;

  /* ..... init index ..... */
  for(i = 0; i < n; i++) index[i] = i;

  for( ; ; ){
    if (right - left <= THRESHOLD) {
      if (p == 0) break;
      p--;
      left  = leftstack[p];
      right = rightstack[p];
    }

    ind = index[(left + right) / 2];
    x = a[ind];

    ind_i = left;
    ind_j = right;

    i = index[ind_i]; 
    j = index[ind_j];

    for( ; ; ) {
      while (a[i] < x) {
	ind_i++;
	i = index[ind_i];
      }

      while (x < a[j]) {
	ind_j--;
	j = index[ind_j];
      }

      if (ind_i >= ind_j) break;

      s = index[ind_i]; index[ind_i] = index[ind_j]; index[ind_j] = s;

      ind_i++; 
      ind_j--;

      i = index[ind_i];
      j = index[ind_j];
    }

    if (ind_i - left > right - j) {
      if (ind_i - left > THRESHOLD) {
	leftstack[p]  = left;
	rightstack[p] = ind_i - 1;
	p++;
	if(p >= STACKSIZE) {
	    printf("*** error : in sort.c#index_sort : stacksize overflow \n");
	    exit(1);
	}
      }
      left = ind_j + 1;
    } else {
      if (right - ind_j > THRESHOLD) {
	leftstack[p]  = ind_j + 1;
	rightstack[p] = right;
	p++;
	if(p >= STACKSIZE) {
	    printf("*** error : in sort.c#index_sort : stacksize overflow \n");
	    exit(1);
	}
      }
      right = ind_i - 1;
    }
  }

  //printf("# n=%d\n", n);
  inssort_index(n, a, index);
  //printf("# OK\n");

}


void qsort2(int n, keytype a[])
{
  int i, j, left, right, p;
  int leftstack[STACKSIZE], rightstack[STACKSIZE];
  keytype x, t;

  left = 0; right = n - 1; p = 0;
  
  for( ; ; ){
    if (right - left <= THRESHOLD) {
      if (p == 0) break;
      p--;
      left = leftstack[p];
      right = rightstack[p];
    }
    x = a[(left + right) / 2];
    i = left; j = right;
    for( ; ; ) {
      while (a[i] < x) i++;
      while (x < a[j]) j--;
      if (i >= j) break;
      t = a[i]; a[i] = a[j]; a[j] = t;
      i++; j--;
    }
    if (i - left > right - j) {
      if (i - left > THRESHOLD) {
	leftstack[p] = left;
	rightstack[p] = i - 1;
	p++;
	if(p >= STACKSIZE) {
	    printf("*** error : in sort.c#qsort2 : stacksize overflow \n");
	    exit(1);
	}
      }
      left = j + 1;
    } else {
      if (right - j > THRESHOLD) {
	leftstack[p] = j + 1;
	rightstack[p] = right;
	p++;
	if(p >= STACKSIZE) {
	    printf("*** error : in sort.c#qsort2 : stacksize overflow \n");
	    exit(1);
	}
      }
      right = i - 1;
    }
  }

  inssort(n, a);

}

static void inssort(int n, keytype a[])
{
  int i, j;
  keytype x;
  
  for (i = 1; i < n; i++) {
    x = a[i];
    for (j = i -1; j >= 0 && a[j] > x; j--)
      a[j + 1] = a[j];
    a[j + 1] = x;
  }
}

static void inssort_index(int n, keytype a[], int index[])
{
  int i, j, ind;
  int y;

  keytype x;

  //printf("# inssort_index: start\n");
  for (i = 1; i < n; i++) {
      
    x = a[index[i]];
    y = index[i];

    for (j = i -1; j >= 0 && a[index[j]] > x; j--) {
      index[j + 1] = index[j];
    }
    index[j + 1] = y;
  }
  //printf("# inssort_index: end\n");
}


	

	

