#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>

#include "opt.h"
#include "astro-lib.h"

double redshift;
double theta;
double th = -1;
double omega = 1;
double dz = 1.0;
double length = 1.0;

main(int argc, char *argv[]) {

    double dc, dl, psd, dm, dv, csd;
    double dt;
    double theta2;
    double tmp;
    double angle;

    optUsage("");

    optrega(&redshift, OPT_DOUBLE, 'z', "redshift", "redshift");
    optrega(&theta, OPT_DOUBLE, 't', "theta", "separtion angle [arcsec]");
    optrega(&th, OPT_DOUBLE, '\0', "radius", "angular radius for solid angle [arcsec]");
    optrega(&length, OPT_DOUBLE, '\0', "length", "comoving separation distance [Mpc]");
    optrega(&omega, OPT_DOUBLE, 'o', "omega", "solid angle [str]");
    optrega(&dz, OPT_DOUBLE, '\0', "dz", "redshift step");

    opt(&argc, &argv);

    dc = get_comoving_distance(Z, redshift);
    dl = get_luminocity_distance(Z, redshift);
    dm = get_distance_modulus(Z, redshift);

    if(th > 0) {
        tmp = th / 60. / 60. / 180 * PI;
        omega = 2 * PI * (1 - cos(tmp));
    }

    dv = get_comoving_volume(redshift, dz, omega);
    dt = lookback_time(0, redshift);

    //
    // arcsec --> radian
    //
    theta2 = theta / 60. / 60. / 180. * PI;
    psd = dl * theta2 / pow((1 + redshift), 2.0);
    csd = dl * theta2 / pow((1 + redshift), 1.0);

    angle = length / dl * pow((1 + redshift), 1.0) / PI * 60 * 60 * 180;

    printf("comoving distance: %lf [Mpc]\n", dc );
    printf("luminocity distance : %lf [Mpc]\n", dl);
    printf("lookback time : %le [yr]\n", dt);
    printf("distance modulus : %lf \n", dm);
    
    printf("proper separation distance : %lf [Mpc] (theta=%lf [arcsec])\n", psd, theta);
    printf("comoving separation distance : %lf [Mpc] (theta=%lf [arcsec])\n", csd, theta);
    printf("separation angle : %lf [arcsec] (length=%lf [Mpc])\n", angle, length);

    printf("comoving volume: %lf [Mpc3] (z=%lf, omega=%le, dz=%lf)\n",
           dv, redshift, omega, dz);
    
    exit(0);
}
