#!/usr/bin/perl

sub ra2sexag($);
sub dec2sexag($);

if(@ARGV > 0) {
    if($ARGV[0] eq "-h" || $ARGV[0] eq "--help")  {
	printf("Usage deg2sexag.pl 123.4 +56.7\n");
	printf("      or deg2sexag.pl < <file>\n");
	exit(1);
    }
}

if(@ARGV == 2) {
   $ra_sexag = ra2sexag($ARGV[0]);
   $dec_sexag = dec2sexag($ARGV[1]);
   printf("%s %s\n", $ra_sexag, $dec_sexag);
   exit(0);
}

while(<STDIN>) {
    @l = split('\s', $_);
    if(@l != 2) {next}
    $ra = ra2sexag($l[0]);
    $dec = dec2sexag($l[1]);
    printf("%s %s\n", $ra, $dec);
}

exit(0);

sub ra2sexag($) {
    my $ra_deg = $_[0];
    my @l, $h, $m, $s, $sexag;

    $hour = $ra_deg / 360 * 24;

    $h = int($hour);

    $min  = ($hour - $h) * 60;

    $m = int($min);

    $sec = ($min - $m) * 60;

    $s = int($sec);

    $mil = int(($sec - $s) * 1000000 + 0.5);

    if($mil == 1000000) {
	$s++;
	$mil = 0;
    }

    if($s == 60) {
	$m++;
	$s = 0;
    }

    if($m == 60) {
	$hour++;
	$m = 0;
    }

    $sexag = sprintf("%02d:%02d:%02d.%06d", $h, $m, $s, $mil);

    return $sexag;
}

sub dec2sexag($) {
    my $dec_deg = $_[0];
    my @l, $d, $m, $s, $sexag;

    $dec_abs = abs($dec_deg);

    $deg = int($dec_abs);
    $min = ($dec_abs - $deg) * 60;
    $m = int(($dec_abs - $deg) * 60);
    $sec = ($min - $m) * 60;
    $s = int($sec);
    $mil = int(($sec - $s) * 1000000 + 0.5);

    if($mil == 1000000) {
	$s++;
	$mil = 0;
    }

    if($s == 60) {
	$m++;
	$s = 0;
    }

    if($m == 60) {
	$deg++;
	$m = 0;
    }

    if($dec_deg >= 0) {
	$sexag = sprintf("+%02d:%02d:%02d.%06d", $deg, $m, $s, $mil);
    } else {
	$sexag = sprintf("-%02d:%02d:%02d.%06d", $deg, $m, $s, $mil);
    }

    return $sexag;
}


exit(0);
