#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "opt.h"
#include "spline.h"
#include "astro-lib.h"
#include "lf.h"

#define H_LF
#define N_WL 9


//
// 1500,2800,u,B,g  z=0.63-3.46
// r,i,z            z=0.65-3.21
// K                z=0.5-2.0
//
static double g_WL[] = {1500., 2800., 3551., 4420., 4686., 6165., 7481., 8931., 22000.};
static double g_m0_K0[] = {-16.75, -17.51, -18.55, -20.71, -20.88, -22.49, -23.05, -23.38, -23.05};
static double g_m0_K1[] = {-2.55, -2.39, -1.86, -1.04, -1.01, 0.02, 0.39, 0.48, 0.58};
static double g_m0_K2[] = {0.406, 0.381, 0.283, 0.153, 0.151, -0.064, -0.123, -0.154, -0.427};
static double g_phi0_K0[] = {0.01585, 0.01426, 0.01252, 0.00536, 0.00561, 0.00239, 0.00150, 0.00191, 0.00197};
static double g_phi0_K1[] = {-0.00834, -0.00759, -0.00635, -0.00233, -0.00256, -0.00032, 0.00067, 0.00028, 0.00290};
static double g_phi0_K2[] = {0.00128, 0.00119, 0.00099, 0.00036, 0.00041, 0.00000, -0.00024, -0.00017, -0.00183};

/**
 *  а z, Ĺ w [A] ΥХɤǴ¬롢餬 mlimit 뤤
 *  ϤθĿ̩ [Mpc-3] ֤
 *
 *  @param z а
 *  @param w Ĺ @ source frame
 *  @param mlimit ʬ¡
 */
double integ(double z, double w, double mmin, double mlimit) {
    double s;
    double m;  // 
    double dm, dn; 

    dm = 0.01;
    s = 0;
    for(m = mmin; m < mlimit; m += dm) {
	dn = lf(z, w, m + dm * 0.5);
	s += dn * dm;
    }

    return s;
}

/**
 *  @param index bandIndex
 *  @param z
 */
double get_param_z2(int index, double z) {
    int i;
    double z2;

    z2 = z;
    i = index;
    if(g_WL[i] < 5000) {
	if(z < 0.63) {
	    //z2 = 0.63;
	    z2 = z;
	    printf("# warning : redshift out of rage (0.63-3.46). z = %lf, wl = %lf\n",z, g_WL[i]);
	} else if(z >= 3.46) {
	    z2 = 3.46;
	    printf("# warning : redshift out of rage (0.63-3.46). z = %lf, wl = %lf\n", z, g_WL[i]);
	}
    } else if(g_WL[i] < 10000) {
	if(z < 0.65) {
	    //z2 = 0.65;
	    z2 = z;
	    printf("# warning : redshift out of rage (0.65-3.21). z = %lf, wl = %lf\n", z, g_WL[i]);
	} else if(z >= 3.21) {
	    z2 = 3.21;
	    printf("# warning : redshift out of rage (0.65-3.21). z = %lf, wl = %lf\n", z, g_WL[i]);
	}
    } else {
	if(z < 0.5) {
	    //z2 = 0.5;
	    z2 = z;
	    printf("# warning : redshift out of rage (0.5-2.0). z = %lf, wl = %lf\n", z, g_WL[i]);
	} else if(z >= 2.0) {
	    z2 = 2.0;
	    printf("# warning : redshift out of rage (0.5-2.0). z = %lf, wl = %lf\n", z, g_WL[i]);
	}
    }
	       
    return z2;
}

/**
 *
 */
double get_param_M0(double z, double w) {

    static double z0 = -1;
    static double logWL[N_WL];
    static double m0_wl[N_WL];
    static double coef_m0[N_WL];

    int i;
    double m0;
    double z2;
    double logWL2;
    
    //
    //
    //
    if(z != z0) {
	for(i = 0; i < N_WL; i++) {
	    logWL[i] = log10(g_WL[i]);
	    z2 = get_param_z2(i, z);
	    m0_wl[i] = g_m0_K0[i] + g_m0_K1[i] * z2 + g_m0_K2[i] * z2 * z2;
	}
	maketable(logWL, m0_wl, coef_m0, N_WL);
	z0 = z;
    }

    //
    // ѥ᡼ͭĹϰϤ 1500-22000A
    // ϰϤۤ϶ͤѤ롣
    //
    logWL2 = log10(w);
    if(w < 1500) {
	logWL2 = log10(1500.);
	printf("# warning : wavelength out of rage (1500-22000). w = %lf\n", w);
    } else if(w >= 22000) {
	logWL2 = log10(22000.);
	printf("# warning : wavelength out of rage (1500-22000). w = %lf\n", w);
    }
    m0 = spline(logWL2, logWL, m0_wl, coef_m0, N_WL);

    return m0;
}

/**
 *
 */
double get_param_alpha(double z, double w) {

    double alpha;
    
    if(w < 4000) {
	alpha = -1.25;
    } else if(w < 5400) {
	alpha = -1.25;
    } else if(w < 10000) {
	alpha = -1.33;
    } else {
	alpha = -1.0;
    }

    return alpha;
}

/**
 *
 */
double get_param_phi(double z, double w) {

    static double z0 = -1;
    static double logWL[N_WL];
    static double phi0_wl[N_WL];
    static double coef_phi0[N_WL];

    int i;
    double z2;
    double phi0;
    double logWL2;

    //
    //
    //
    if(z != z0) {
	for(i = 0; i < N_WL; i++) {
	    logWL[i] = log10(g_WL[i]);
	    z2 = get_param_z2(i, z);
	    phi0_wl[i] = g_phi0_K0[i] + g_phi0_K1[i] * z2 + g_phi0_K2[i] * z2 * z2;
	}
	maketable(logWL, phi0_wl, coef_phi0, N_WL);
	z0 = z;
    }

    //
    // ѥ᡼ͭĹϰϤ 1500-22000A
    // ϰϤۤ϶ͤѤ롣
    //
    logWL2 = log10(w);
    if(w < 1500) {
	logWL2 = log10(1500.);
	printf("# warning : wavelength out of rage (1500-22000). w = %lf\n", w);
    } else if(w >= 22000) {
	logWL2 = log10(22000.);
	printf("# warning : wavelength out of rage (1500-22000). w = %lf\n", w);
    }
    phi0 = spline(logWL2, logWL, phi0_wl, coef_phi0, N_WL);

    return phi0;
}


/**
 *  а z, Ĺ w [A] ΥХɤǴ¬롢餬 m Ǥ
 *  ϤʬĿ̩ [mag-1.Mpc-3]
 * 
 *  @param z redshift
 *  @param w source frame ǤĹ
 *  @param m 
 */
double lf(double z, double w, double m) {
    double m0;
    double phi0;
    double alpha;
    double x, tmp;
    double phi;

    //
    //
    //
    if(w <= 0) {
	fprintf(stderr, "negative wavelength in lf() : wavelength = %lf\n", w);
	exit(1);
    }

    if(z < 0.0 || z > 10.0) {
	fprintf(stderr, "redshift out of range (0--10) in lf() : z = %lf", z);
	exit(1);
    }

    //
    //
    //
    m0 = get_param_M0(z, w);
    alpha = get_param_alpha(z, w);
    phi0 = get_param_phi(z, w);

    //
    //
    //
    tmp = 0.4 * (m0 - m);
    x = pow(10., tmp);
    phi = 0.4 * phi0 * log(10.) * pow(x, (alpha + 1)) * exp(-x);

    return phi;
}
