#define H0 70  /* km/s/Mpc */
#define C  3e5 /* km/s */

#define OMEGA_M 0.3
#define OMEGA_R 0.0
#define OMEGA_L 0.7
#define OMEGA_K 0.0

#ifndef PI
#define PI 3.141592654
#endif

#define N_DIST_CONV 100001

#define Z   0  /* redshift */
#define DC  1  /* comoving distance */
#define DL  2  /* luminocity distance */
#define DA  3  /* angular diameter distance */
#define DM  4  /* transverse comoving distance */


double get_comoving_distance(int flag, double x);
double get_luminocity_distance(int flag, double x);
double get_angular_diameter_distance(int flag, double x);
double get_angular_diameter_distance2(double z1, double z2);
double get_distance_modulus(int flag, double x);
double get_comoving_volume(double z, double dz, double omega) ;
double lookback_time(int flag, double x) ;

double z2d(double z);
double d2z(double d);
double distance_conv(int flag, double x);

void xyz2radec(double x, double y, double z, double *ra, double *dec);
void radec2xyz(double ra, double dec, double *x, double *y, double *z);

void xyz2tp(double x, double y, double z, double *th, double *ph);
void tp2xyz(double th, double ph, double *x, double *y, double *z);

void sexag2deg(char *ra_str, char *dec_str, double *ra, double *dec);
void deg2sexag(double ra, double dec, char *ra_str, char *dec_str) ;
int parse_sexagesimal(char *str, double  value[3]);

double angdiff(double ra1, double dec1, double ra2, double dec2);
