#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "matutil.h"
#include "spline.h"

void maketable2(int nx, int ny, double *x, double *y, double **z, double **c)
{
  int i, j;

  for(i = 0; i < nx; i++) {
    maketable(y, z[i], c[i], ny);
  }
  
  return;
}

/* calculate interpolated z value at (x,y) */
double spline2(int nx, int ny,
	       double x, double y, double *x0, double *y0, 
	       double **z0, double **c0)
{
  int i;
  double *z1, *c1;
  double ans;
  
  /* out of range check */
  if(x <  x0[0])      return 0;
  if(x >= x0[nx - 1]) return 0;
  
  if(y <  y0[0])      return 0;
  if(y >= y0[ny - 1]) return 0;

  z1 = (double *) calloc(nx, sizeof(double));
  c1 = (double *) calloc(nx, sizeof(double));

  /* calculate z value at x */
  for(i = 0; i < nx; i++) {
    z1[i] = spline(y, y0, z0[i], c0[i], ny); /* z @ (x[i],y) */
  }
  /* make a spline coefficient table */
  maketable(x0, z1, c1, nx);
  
  ans = spline(x, x0, z1, c1, nx);
  
  free(z1);
  free(c1);

  return ans;
  
}

void maketable(double x[], double y[], double z[], int n)
{
  int i;
  double t;
  static double *h, *d;

  h = new_vector(n);
  d = new_vector(n);

  z[0] = 0; z[n - 1] = 0;
  for (i = 0; i < n - 1; i++) {
    h[i    ] = x[i + 1] - x[i];
    d[i + 1] =(y[i + 1] - y[i]) / h[i];
  }
  z[1] = d[2] - d[1] - h[0] * z[0];
  d[1] = 2 * (x[2] -x[0]);
  for (i = 1; i < n -2; i++) {
    t = h[i] / d[i];
    z[i + 1] = d[i + 2] - d[i + 1] - z[i] * t;
    d[i + 1] = 2 * (x[i + 2] - x[i]) - h[i] * t;
  }
  z[n - 2] -= h[n - 2] * z[n - 1];
  for (i = n - 2; i > 0; i--) {
    z[i] = (z[i] - h[i] * z[i + 1]) / d[i];
  }
  free_vector(h);
  free_vector(d);
}

double spline(double t, double x[], double y[], double z[], int n)
{
  int i, j, k;
  double d, h;
  double tmp;

  i = 0; j = n - 1;
  while (i < j) {
    k = (i + j) / 2;
    if (x[k] < t) i = k + 1; else j = k;
  }
  if (i > 0) i--;
  h = x[i + 1] - x[i]; d = t - x[i];

  tmp = (((z[i + 1] - z[i]) * d / h + z[i] * 3) * d
	 + ((y[i + 1] - y[i]) / h
	    - (z[i] * 2 + z[i + 1]) * h)) * d + y[i];
  return tmp;
/*
  return (((z[i + 1] - z[i]) * d / h + z[i] * 3) * d
	  + ((y[i + 1] - y[i]) / h
	  - (z[i] * 2 + z[i + 1]) * h)) * d + y[i];
*/
}
