#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "opt.h"
#include "astro-lib.h"

double ra1, dec1, ra2, dec2;
char *file;

int main(int argc, char *argv[]) {
    FILE *fp;
    double d;

    optUsage("");

    optrega(&ra1,  OPT_DOUBLE, '\0', "ra1",  "ra1");
    optrega(&dec1, OPT_DOUBLE, '\0', "dec1", "dec1");
    optrega(&ra2,  OPT_DOUBLE, '\0', "ra2",  "ra2");
    optrega(&dec2, OPT_DOUBLE, '\0', "dec2", "dec2");
    optrega(&file, OPT_VSTRING, 'f', "file", "file: (ra,dec) list");
    
    opt(&argc, &argv);

    if(file == NULL) {
        d = angdiff(ra1, dec1, ra2, dec2);
        printf("%f\n", d);
    } else {
        fp = fopen(file, "r");
        
        while(! feof(fp)) {
            fscanf(fp, "%lf %lf", &ra2, &dec2);
            if(feof(fp)) break;
            d = angdiff(ra1, dec1, ra2, dec2);
            printf("%lf %lf %f\n", ra2, dec2, d);
        }

    }
    
    exit(0);
}
