/**
 *
 */
void plot_map(double ra, double dec, double rad)
{
    //
    // ϰϤ׻
    //
    double xmin, xmin, ymin, ymax;
    double dy, dx;
    dx = rad / cos(dec/180.*3.141592654);
    dy = rad;
    xmin = ra - dx;
    xmax = ra + dx;
    ymin = dec - dy;
    ymax = dec + dy;

    //
    // ǡ
    //
    double x, y;
    TNtuple* nt = new TNtuple("object", "object", "x:y");
    string buf;
    ifstream data("radec.dat");
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>x>>y; 
        nt->Fill(x, y);
    }
    data.close();

    //
    // ν
    //
    gROOT->SetStyle("Plain");     // ɽ off
    gStyle->SetOptTitle(kFALSE);  // ȥä
    gStyle->SetOptStat(kFALSE);   // ׾ä
    TCanvas* c1 = new TCanvas("c1", "c1", 400, 400);
    gStyle->SetNdivisions(505, "X"); // XΥ
    gStyle->SetNdivisions(505, "Y"); // YΥ

    //
    // XY ɽϰϤꤹ뤿ζҥȥ
    //
    TH1F *waku = new TH1F("waku", "title", 2, xmin, xmax);
    waku->SetMinimum(ymin);
    waku->SetMaximum(ymax);
    waku->Draw();
    waku->GetXaxis()->SetTitle("RA");  // XΥȥ
    waku->GetYaxis()->SetTitle("Dec"); // YΥȥ

    //
    // ϰϡʱߡ
    //
    TEllipse *region = new TEllipse(ra, dec, dx, dy);
    region->Draw("same");

    //
    // ŷΥץå
    //
    nt->SetMarkerStyle(20);       // ޡ
    nt->SetMarkerColor(2);        // ޡο
    nt->SetMarkerSize(0.4);       // ޡ
    nt->Draw("y:x", "", "same");

    //
    // ץåȤ eps ե˽񤭽Ф
    //
    c1->Print("map.eps");
}
