#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>

#include "opt.h"
#include "astro-lib.h"
#include "qsort2.h"

#define N_TH 100
#define N_PH 10000
#define PI 3.141592654

int num_min = 20;
double center_ra;
double center_dec;
double bin_size = 10.1;
double bin_min = 0;
double bin_max = 2000;

double mask_rmax = 4.0; // arcsec 

void rotate(double mat[3][3],double x, double y, double z,
	    double *x2, double *y2, double *z2);

/**
 *
 */
int main(int argc, char *argv[])
{
    int i, j, k;
    int ind_t;
    int num[N_TH];
    double ra, dec;
    double th, ph;
    double t2, p2;
    double x, y, z;
    double x2, y2, z2;
    double rot[3][3];

    double ph_mem[N_TH][N_PH];
    double *diff;
    double s1, s2;
    double pre;
    double dead[1000], dead_frac[N_TH];
    double r1, r2, ds;
    double d, d_th;
    double ave_den, exp, dead_sum, ave_dis, sig_dis, mask_area;
    
    optUsage("[OPTIONS]");
    optrega(&center_ra, OPT_DOUBLE, 'r', "ra", "center ra");
    optrega(&center_dec, OPT_DOUBLE, 'd', "dec", "center dec");
    //optrega(&bin_min, OPT_DOUBLE, '\0', "min", "bin minimum");
    //optrega(&bin_max, OPT_DOUBLE, '\0', "max", "bin maximum");
    optrega(&bin_size, OPT_DOUBLE, '\0', "size", "bin size (arcsec)");
    optrega(&mask_rmax, OPT_DOUBLE, '\0', "mask-rmax", "mask size (arcsec)");
    optrega(&num_min, OPT_DOUBLE, '\0', "num-min", "minimum number for estimating bad fraction");

    opt(&argc, &argv);

    //
    // degree
    //
    d_th = bin_size / 60. / 60.;  
    th = (90 - center_dec) / 180. * PI;
    ph = center_ra / 180. * PI;

    //printf("%lf %lf\n", th, ph);
    
    rot[0][0] = cos(th) * cos(ph);
    rot[0][1] = cos(th) * sin(ph);
    rot[0][2] = -sin(th);
    rot[1][0] = -sin(ph);
    rot[1][1] = cos(ph);
    rot[1][2] = 0;
    rot[2][0] = sin(th) * cos(ph);
    rot[2][1] = sin(th) * sin(ph);
    rot[2][2] = cos(th);

    //
    //
    //
    for(i = 0; i < N_TH; i++) {
	num[i] = 0;
    }

    //
    // ph_mem[][]  num[] 
    //
    while(feof(stdin) == 0) {
	fscanf(stdin, "%lf %lf", &ra, &dec);
	if(feof(stdin) == 1) break;
	//
	radec2xyz(ra, dec, &x, &y, &z);
	//
	rotate(rot, x, y, z, &x2, &y2, &z2);
	//
	xyz2tp(x2, y2, z2, &t2, &p2);
	//
	ind_t = (int) (t2 / d_th);
	//
	if(ind_t < N_TH) {
	    if(p2 <= 0) {
		p2 += 360;
	    }
	    ph_mem[ind_t][num[ind_t]] = p2;
	    num[ind_t]++;
	}
    }

    //
    //dead ΰγ롣count = 0 ξϤȤФ
    //
    for(i = 0; i < N_TH; i++) {
	if(num[i] < num_min) {
            dead_frac[i] = 0;
            continue;
        }

	qsort2(num[i], ph_mem[i]);
        //
	// ph_mem[i][num[i]] = ph_mem[i][0] + 360;
	// ave_dis = 360 / (double) num[i];
        //

        //
        // phi κΥǥ롣
        //
        diff = (double *) calloc(num[i], sizeof(double));
	pre = ph_mem[i][num[i] - 1] - 360;
	for(j = 0; j < num[i]; j++) {
            diff[j] = fabs(ph_mem[i][j] - pre);
	    pre = ph_mem[i][j];
	}
	qsort2(num[i], diff);
        ave_dis = diff[num[i] / 2];
        sig_dis = diff[(int) (num[i] * 0.84)] - ave_dis;

        //
        //
        //
	pre = ph_mem[i][num[i] - 1] - 360;
        k = 0;
        s1 = 0;
        s2 = 0;
	for(j = 0; j < num[i]; j++) {
            diff[k] = fabs(ph_mem[i][j] - pre);
	    pre = ph_mem[i][j];
            if(diff[k] > 3 * sig_dis) {
                continue;
            } else {
                s1 += diff[k];
                s2 += (diff[k] * diff[k]);
                k++;
            }
	}

        if(k > 0) {
            ave_dis = s1 / (double) k;
        } else {
            ave_dis = 0;
        }
        if(k > 1) {
            sig_dis =  (s2 - ave_dis * ave_dis * k) / (double) (k - 1);
            sig_dis = sqrt(sig_dis);
        } else {
            sig_dis = 0;
        }
        

        free(diff);
        
        //
        //
        //
	pre = ph_mem[i][num[i] - 1] - 360;
	k = 0;
	for(j = 0; j < num[i]; j++) {
	    d = ph_mem[i][j] - pre;

            //printf("# %d %d %lf %lf %lf %d\n", i, j, ph_mem[i][j], d, ave_dis, num[i]);

	    if(fabs(d - ave_dis) >= sig_dis * 3) {
		//
		//
		//
		if(k >= 100) {
		    if(dead[0] < ph_mem[i][j] - pre) {
			dead[0] = ph_mem[i][j] - pre;
		    }
		} else {
		    dead[k] = ph_mem[i][j] - pre;
                    //printf("# dead = %lf\n", dead[k]);
		    k++;
		}

		qsort2(k, dead);
	    }
	    pre = ph_mem[i][j];
	}

        if(ave_dis > 0) {
            ave_den = 1. / ave_dis;
        } else {
            ave_den = num[i] / 360.;
        }

	dead_sum = 0;

        //printf("# i=%d\n", i);

	for(j = k - 1; j >= 0; j--) {
	    exp = ave_den * dead[j];
            //printf("# ave_den=%lf dead=%lf exp=%lf sig=%lf\n", ave_den, dead[j], exp, sqrt(exp));
	    if(exp - sqrt(exp) * 3  > 0 && exp > num_min) {
		dead_sum += dead[j];
	    }
	}
	dead_frac[i] = dead_sum / 360;
        //printf("# dead_frac=%lf\n", dead_frac[i]);
    }

    //
    //
    //
    printf("# number r_middle earea    bad_fraction  number\n");
    printf("# ------ arcsec   arcmin2  ----          ---\n");
    for(i = 0; i < N_TH; i++) {
	r1 = d_th * i * 60. * 60.;
	r2 = d_th * (i + 1) * 60. * 60.;
	//
	// 濴Υޥΰ
	//
	if(mask_rmax > r1) {
	    if(mask_rmax <= r2) {
		mask_area = PI * (mask_rmax * mask_rmax - r1 * r1);
	    } else {
		mask_area = PI * (r2 * r2 - r1 * r1);
	    }
	} else {
	    mask_area = 0;
	}
	if(num[i] <= 0) {
	    dead_frac[i] = 0.0;
	}
	ds = (PI * (r2 * r2 - r1 * r1) - mask_area)  * (1 - dead_frac[i]);
	printf("%d %lf %le %lf %d\n", i, (i + 0.5) * d_th * 60. * 60., ds/60./60., dead_frac[i], num[i]);
    }

    exit(0);
}


void rotate(double mat[3][3],
	    double x, double y, double z,
	    double *x2, double *y2, double *z2)
{
    int i, j;
    double v[3], v2[3];

    v[0] = x;
    v[1] = y;
    v[2] = z;

    for(i = 0; i < 3; i++) {
	v2[i] = 0;
	for(j = 0; j < 3; j++) {
	    v2[i] += mat[i][j] * v[j];
	}
    }

    *x2 = v2[0];
    *y2 = v2[1];
    *z2 = v2[2];

}

	    
