#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>

#include "opt.h"

#define NBIN 60

int num_bin = 0;

double r[NBIN];
double hist[NBIN];
int count[NBIN];
double area[NBIN];

double density[NBIN];
double density_err[NBIN];

double fg_rmin = 0.0;
double fg_rmax = 1.0;
double bg_rmin = 1.0;
double bg_rmax = 2.5;

void read();
void check();

int main(int argc, char *argv[])
{
    optUsage("check-uniform2 [OPTIONS] < <file>");

    optrega(&fg_rmin, OPT_DOUBLE, '\0', "fg-rmin", "foreground rmin [Mpc]");
    optrega(&fg_rmax, OPT_DOUBLE, '\0', "fg-rmax", "foreground rmax [Mpc]");
    optrega(&bg_rmin, OPT_DOUBLE, '\0', "bg-rmin", "background rmin [Mpc]");
    optrega(&bg_rmax, OPT_DOUBLE, '\0', "bg-rmax", "background rmax [Mpc]");
    opt(&argc, &argv);

    
    read();

    check();

    exit(0);
}

void read()
{
    int i = 0;
    //
    //
    //
    while(feof(stdin) == 0) {

	fscanf(stdin, "%lf %lf %lf",
	       &r[i], &density[i], &density_err[i]);

	if(feof(stdin) == 1) {
	    break;
	}
	
	i++;
	if(i >= NBIN) break;
    }
    num_bin = i;
    printf("# num_bin = %d\n", num_bin);
}

void check()
{
    int i = 0, n;
    int num_bg;
    double s0, s1, s2, s3, s4;
    double fg0, fg1, fg2, fg, fg_err;
    double bg0, bg1, bg2, bg, bg_err;
    double src_sig;
    double den, err, ave, sig;
    double den2, err2, area2, dev2;
    double den3, err3, area3, dev3, sig3;
    double sig2, dev;
    double chi2;
    double cor;

    double ave_bg;
    
    
    //
    //
    //
    s1 = s2 = s3 = 0;
    fg0 = fg1 = fg2 = 0;
    bg0 = bg1 = bg2 = 0;
    num_bg = 0;
    
    for(i = 0; i < num_bin; i++) {
	if(r[i] >= bg_rmin && r[i] <= bg_rmax) {
	    s3 += density[i];
	    num_bg++;
	}
    }

    ave_bg = s3 / (double) num_bg;
    printf("AVE_BG: %lf\n", ave_bg);


    //
    //
    //
    chi2 = 0;
    s3 = s4 = 0;
    n = 0;
    for(i = 0; i < num_bin; i++) {

	if(r[i] >= fg_rmin && r[i] < fg_rmax) {
	    s3 += (density[i] - ave_bg);
	    s4 += (density_err[i] * density_err[i]);
	}

	if(r[i] >= bg_rmin && r[i] < bg_rmax) {
	    sig2 = density_err[i];
	    den  = density[i];
	    ave  = ave_bg;
	    err  = density_err[i];
	    if(sig2 > 0) {
		dev = (den - ave) / sig2;
		chi2 += (den - ave) * (den - ave) / err / err;
	    } else {
		dev = 0;
	    }
	    n++;
	    printf("DEV: %lf %lf %lf %lf %lf\n", r[i], ave, dev, sig2, den);
	}
    }

    printf("# CHI2: %lf / %d\n", chi2, (n - 1));
    printf("# EXCESS: %lf +- %lf\n", s3, sqrt(s4));
}

