#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>

#include "imglib.h"

void normalize_image(Image *image)
{
  int i, j;
  double sum = 0;
  
  for(i = 0; i < image->nx; i++) {
    for(j = 0; j < image->ny; j++) {
      sum += image->image[i][j];
    }
  }

  for(i = 0; i < image->nx; i++) {
    for(j = 0; j < image->ny; j++) {
      image->image[i][j] /= sum;
    }
  }

  return;
}

void init_image(int nx, int ny, Image *image)
{
  int i, j;

  image->nx = nx;
  image->ny = ny;
  image->image = newmat(nx, ny);
  image->err   = newmat(nx, ny);
  
  for(i = 0; i < nx; i++)
    for(j = 0; j < ny; j++)
      image->err[i][j] = 1.;

  return;
}

void free_image(Image *a)
{

  free_matrix(a->image);
  free_matrix(a->err);

  return;
}

void clear_image(Image *a)
{
  int i, j;

  for(i = 0; i < a->nx; i++)
    memset((void *) a->image[i], 0, sizeof(SCALAR) * a->ny);  

  return;
}



