#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "matutil.h"

void error(char *message)
{
  fprintf(stderr, "\n%s\n", message);
  exit(0);
}

vector newvec(int n)
{
  return (vector) calloc(n, sizeof(SCALAR));
}

matrix newmat(int nrow, int ncol)
{
  int i;
  matrix a;

  a = (matrix) calloc(nrow, sizeof(vector));
  if (a == NULL) return NULL;
  a[0] = (vector) calloc(nrow * ncol, sizeof(SCALAR));
  for (i = 1; i < nrow; i++) {
    a[i] = a[i - 1] + ncol;
  }

  return a;
}

/*
matrix newmat(int nrow, int ncol)
{
  int i;
  matrix a;

  a = (matrix) calloc((nrow + 1),  sizeof(char *) );
  if (a == NULL) return NULL;
  for (i = 0; i < nrow; i++) {
    a[i] = (vector) calloc(ncol, sizeof(SCALAR));
    if (a[i] == NULL) {
      while (--i >= 0) free(a[i]);
      free(a); return NULL;
    }
  }
  a[nrow] = NULL;
  return a;
}
*/

vector new_vector(int n)
{
  vector v;

  v = newvec(n);
  if (v == NULL) error("ΰ­");
  return v;
}

matrix new_matrix(int nrow, int ncol)
{
  matrix a;

  a = newmat(nrow, ncol);
  if (a == NULL) error("ΰ­");
  return a;
}

void free_vector(vector v)
{
  free(v);
}

void free_matrix(matrix a)
{
//  matrix b;

//  b = a;
//  while (*b != NULL) free(*b++);

  free(a[0]);

  free(a);
}
/*
void free_matrix(matrix a)
{
  matrix b;

  b = a;
  while (*b != NULL) free(*b++);
  free(a);
}
*/

double innerproduct(int n, vector u, vector v)
{
  int i, n5;
  double s;

  s = 0; n5  = n % 5;
  for (i = 0; i < n5; i++) s += u[i]*v[i];
  for (i = n5; i < n; i += 5)
    s += u[i]*v[i] + u[i+1]*v[i+1] + u[i+2]*v[i+2]
                   + u[i+3]*v[i+3] + u[i+4]*v[i+4];
  return s;
}

void vecprint(vector v, int n, int perline, char *format)
{
  int j, k;

  k = 0;
  for (j = 0; j < n; j++) {
    printf(format, v[j]);
    if (++k >= perline) { k = 0; printf("\n"); }
  }
  if (k != 0) printf("\n");
}

int matprint(matrix a, int ncol, int perline, char *format)
{
  int i,n;

  for (i = 0; a[i] != NULL; i++) {
    vecprint(a[i], ncol, perline, format);
    if (ncol > perline) printf("\n");
  }
  n = 0;
  return n;
}


void vecinput(FILE *fp, vector v, int n, int perline, char *format)
{
  int j, k;

  k = 0;
  for (j = 0; j < n; j++) {
    fscanf(fp, format, v[j]);
    printf("%s\n",format);
/*    if (++k >= perline) { k = 0; fscanf(fp,"%*", trash); } */
  }
}


int matinput(FILE *fp, matrix a, int ncol, int perline, char *format)
{
  int i,n;

  for (i = 0; a[i] != NULL; i++) { 
    vecinput(fp, a[i], ncol, perline, format);
/*    if (ncol > perline) fscanf(fp, "%*", dummy); */
  }
  n = 0;
  return n;
}

double lu(int n, matrix a, int *ip)
{
  int i, j, k, ii, ik;
  double t, u, det;
  vector weight;

   weight = new_vector(n);
   det = 0;
   for (k = 0 ; k < n; k++) {
     ip[k] = k;
     u = 0.;
     for ( j = 0; j < n; j++) {
       t = fabs(a[k][j]); if (t > u) u = t;
     }
     
     if (u == 0.) goto EXIT;
     weight[k] = 1 / u;
   }

   det = 1;
   for (k = 0; k < n; k++) {
     u = -1;
     j = k;
     for (i = k; i < n; i++) {
       ii = ip[i];
       t = fabs(a[ii][k]) * weight[ii];
       if (t > u) { u = t; j = i; }
     }
     ik = ip[j];
     if (j != k) {
       ip[j] = ip[k]; ip[k] = ik;
       det = -det;
     }
     u = a[ik][k]; det *= u;
     if (u == 0) goto EXIT;
     for (i = k + 1; i < n; i++) {
       ii = ip[i];
       t = (a[ii][k] /= u);
       for (j = k +1; j < n; j++)
	 a[ii][j] -= t * a[ik][j];
     }
   }
EXIT:
   free_vector(weight);
   return det;
}

/**
 *
 */
double matinv(int n, matrix a, matrix a_inv)
{
   int    i, j, k, ii;
   double t, det;
   int    *ip;

   ip = (int *) malloc(sizeof(int) * n);
   if (ip == NULL) error("ΰ­");
   det = lu(n, a, ip);
   if (det != 0) 
      for (k = 0; k < n; k++) {
         for (i = 0; i < n; i++) {
            ii = ip[i]; t = (ii == k);
            for (j = 0; j < i; j++)
               t -= a[ii][j] * a_inv[j][k];
            a_inv[i][k] = t;
	  }
          for (i = n - 1; i >= 0; i--) {
             t = a_inv[i][k]; ii = ip[i];
             for (j = i + 1; j < n; j++)
                t -= a[ii][j] * a_inv[j][k];
             a_inv[i][k] = t / a[ii][i];
	  }
       }
    free(ip);
    return det;
 }

double matinv0(int n, matrix a)
{
  int     i, j, k;
  double  t, u, det;

  det = 1.;
  for(k = 0; k < n; k++) {
    t = a[k][k]; det *= t;
    for(i = 0; i < n; i++) a[k][i] /= t;
    a[k][k] = 1 / t;
    for(j = 0; j < n; j++)
      if(j != k) {
	u = a[j][k];
	for(i = 0; i < n; i++) 
	  if(i != k)
	    a[j][i] -= a[k][i] * u;
	  else 
	    a[j][i] = -u /t;
      }
  }

  return det;
}

