/***********************************************************
	statutil.c -- ϗʃf[^
***********************************************************/
//#include "matutil.c"   /* sp̏W */
#include <stdio.h>
#include <errno.h>     /* {\tt errno} */
#include <limits.h>    /* {\TT INT\_MAX} */
#include <math.h>      /* {\tt fabs()} */
#include <string.h>    /* {\tt strchr()} */
#include "matutil.h"

#define READERROR -1.00E+37;  /* ǍG[ */
#define MISSING   -0.98E+37;  /* l */
#define readerror(x) ((x) < -0.99E+37)
#define missing(x)   ((x) < -0.97E+37)

double getnum(FILE *datafile)
{
	double x;
	char *rest, s[83];

	do {
		if (fscanf(datafile, "%81s%*[^ \t\n]", s) != 1)
			return READERROR;
	} while (strchr("0123456789+-.", s[0]) == NULL);
	if (s[0] == '.' && s[1] == '\0') return MISSING;
	s[81] = '?';  s[82] = '\0';  x = strtod(s, &rest);
	if (errno == 0 && *rest == '\0' && fabs(x) <= 0.97E+37)
		return x;
	errno = 0;  return READERROR;
}

FILE *open_data(char *filename, int *addr_n, int *addr_m)
{
	FILE *datafile;
	double x, y;

	*addr_n = *addr_m = 0;
	if ((datafile = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "f[^t@CJ܂.\n");
		return NULL;
	}
	x = getnum(datafile);  y = getnum(datafile);
	if (x <= 0 || x > INT_MAX || y <= 0 || y > INT_MAX) {
		fprintf(stderr, "sE񐔂ǂ߂܂.\n");
		fclose(datafile);  return NULL;
	}
	*addr_n = (int)x;  *addr_m = (int)y;
	fprintf(stderr, "%d s %d ̃f[^ł.\n",
		*addr_n, *addr_m);
	return datafile;
}

int read_data(FILE *datafile, int n, int m, matrix x)
{
	int i, j, err;
	unsigned long missings;
	double t;

	err = 0;  missings = 0;
	for (i = 0; i < n; i++) for (j = 0; j < m; j++) {
		if (err) {  x[j][i] = READERROR;  continue;  }
		t = getnum(datafile);  x[j][i] = (SCALAR)t;
		if (! missing(t)) continue;
		if (readerror(t)) {
			fprintf(stderr, "Ǎ݃G[(%d,%d)\n", i+1, j+1);
			err = 2;
		} else missings++;
	}
	fprintf(stderr, "ǍݏI (l %lu )\n", missings);
	return err | (missings != 0);
}

/*
֌W
                1      n         _         _
	r = ---------  (x{i} - x)(y{i} - y)
            (n-1)SxSy

߂3ނ̃vOłB
*/

float corrcoef1(int n, float x[], float y[]) {
    int i;
    float sx, sy, sxx, syy, sxy, dx, dy;

    sx = sy = sxx = syy = sxy = 0;
    for (i = 0; i < n; i++) {
        sx += x[i];  sy += y[i];
    }
    sx /= n;  sy /= n;
    for (i = 0; i < n; i++) {
        dx = x[i] - sx;  dy = y[i] - sy;
        sxx += dx * dx;  syy += dy * dy;  sxy += dx * dy;
    }
    sxx = sqrt(sxx / (n - 1));
    syy = sqrt(syy / (n - 1));
    
    return sxy /= (n - 1) * sxx * syy;
}

float corrcoef2(int n, float x[], float y[])
{
    int i;
    float sx, sy, sxx, syy, sxy;

    sx = sy = sxx = syy = sxy = 0;
    for (i = 0; i < n; i++) {
        sx += x[i];  sy += y[i];
        sxx += x[i] * x[i];
        syy += y[i] * y[i];
        sxy += x[i] * y[i];
    }
    sx /= n;  sxx = (sxx - n * sx * sx) / (n - 1);
    sy /= n;  syy = (syy - n * sy * sy) / (n - 1);
    if (sxx > 0) sxx = sqrt(sxx);  else sxx = 0;
    if (syy > 0) syy = sqrt(syy);  else syy = 0;
    sxy = (sxy - n * sx * sy) / ((n - 1) * sxx * syy);

    return sxy;
}

float corrcoef3(int n, float x[], float y[])
{
    int i;
    float sx, sy, sxx, syy, sxy, dx, dy;

    sx = sy = sxx = syy = sxy = 0;
    for (i = 0; i < n; i++) {
        dx = x[i] - sx;  sx += dx / (i + 1);
        dy = y[i] - sy;  sy += dy / (i + 1);
        sxx += i * dx * dx / (i + 1);
        syy += i * dy * dy / (i + 1);
        sxy += i * dx * dy / (i + 1);
    }
    sxx = sqrt(sxx / (n - 1));
    syy = sqrt(syy / (n - 1));
    sxy /= (n - 1) * sxx * syy;

    return sxy;
}

