#! /usr/bin/perl
## $Id: makeopth.pl,v 1.1.1.1 2006/09/08 10:07:43 fjvo03 Exp $
## Automatically generates file opt_regt.c
## Automatically generates the part of opt.h that is between the lines
## BEGIN_AUTOGENERATED and END_AUTOGENERATED
## This is not expected to be part of the usual `make' process; it's
## just a convenience for the developer (me).

if (@ARGV) {
    print "Usage: cp opt.h tmp.h             ;; just in case!\n";
    print "       perl makeopth.pl\n";
    print "-> generates a new 'opt_regt.c', alters 'opt.h'\n";
    exit;
}

%otype = (
	  NUL, "void ",
	  INT, "int ",
	  SHORT, "short ",
	  LONG, "long ",
	  CHAR, "char ",
	  UINT, "unsigned int ",
	  USHORT, "unsigned short ",
	  ULONG, "unsigned long ",
	  UCHAR, "unsigned char ",
	  FLOAT, "float ",
	  DOUBLE, "double ",
	  FLAG, "int ",
	  NEGFLAG, "int ",
	  ABSFLAG, "int ",
	  ABSNEGFLAG, "int ",
	  INTLEVEL, "int ",
	  STRING, "char *",
	  CSTRING, "char ",
	  UNDELIM, "char *",
	  UNSINT, "unsigned int ",
	  VSTRING, "char *",
	  UNDELIMV, "char *",
	  UNDELIMC, "char ",
	  );

print "Making new opt_regt.c file...";

open(OPTU,"> opt_regt.c");
print OPTU "/* opt_regt.c */\n";
print OPTU "/* Note: this file generated automatically from makeopth.pl */\n";
print OPTU "/* Edits to this file may be lost! */\n";
print OPTU "#include <opt.h>\n";

foreach $k (keys %otype) {
    print OPTU "inline int\n";
    print OPTU "optrega_$k($otype{$k}*v, char c, char *n, char *B) {\n";
    print OPTU "      return optrega(v,OPT_$k,c,n,B);\n}\n";
    print OPTU "inline int\n";
    print OPTU "optreg_$k($otype{$k}*v, char c, char *B) {\n";
    print OPTU "      return optreg(v,OPT_$k,c,B);\n}\n";
    print OPTU "inline int\n";
    print OPTU "optregc_$k($otype{$k}*v, char c) {\n";
    print OPTU "      return optregc(v,OPT_$k,c);\n}\n";
    print OPTU "inline int\n";
    print OPTU "optregs_$k($otype{$k}*v, char *n) {\n";
    print OPTU "      return optregs(v,OPT_$k,n);\n}\n";
    print OPTU "inline int\n";
    print OPTU "optregcb_$k($otype{$k}*v, char c, char *B) {\n";
    print OPTU "      return optregcb(v,OPT_$k,c,B);\n}\n";
    print OPTU "inline int\n";
    print OPTU "optregsb_$k($otype{$k}*v, char *s, char *B) {\n";
    print OPTU "      return optregsb(v,OPT_$k,s,B);\n}\n";
}
close OPTU;

print "ok\n";
print "Altering opt.h file...";

open(OPTH,"opt.h");
open(NEW,">tmp-opt.h");
$ag=0;
while (<OPTH>) {
    if (/BEGIN_AUTOGENERATED/) {
	$ag=1;
    }
    print NEW if ($ag == 0);
    if (/END_AUTOGENERATED/) {
	print NEW "/* BEGIN_AUTOGENERATED */\n";
	foreach $k (keys %otype) {
	    print NEW "#define $k OPT_$k\n";
	    print NEW "extern int ";
	    print NEW "optrega_$k($otype{$k}*v, char c, char *n, char *B);\n";
	    print NEW "extern int ";
	    print NEW "optreg_$k($otype{$k}*v, char c, char *B);\n";
	    print NEW "extern int ";
	    print NEW "optregc_$k($otype{$k}*v, char c);\n";
	    print NEW "extern int ";
	    print NEW "optregs_$k($otype{$k}*v, char *n);\n";
	    print NEW "extern int ";
	    print NEW "optregcb_$k($otype{$k}*v, char c, char *B);\n";
	    print NEW "extern int ";
	    print NEW "optregsb_$k($otype{$k}*v, char *s, char *B);\n";
	}
	print NEW "/* END_AUTOGENERATED */\n";
	$ag=0;
    }
}
close OPTH;
close NEW;

open(OPTH,">opt.h");
open(NEW,"tmp-opt.h");
while (<NEW>) {
    print OPTH;
}
close OPTH;
close NEW;
unlink "tmp-opt.h";

print "ok\n";

__END__
    
      



	
