#!/bin/sh -f
#
# JVO init script for sh
#

#
#
#
if [ -z "$JVO_TOOLS" ]; then
   echo "you must set JVO_TOOLS"
   exit 1
fi

#
#
#
if [ -z "$HEADAS" ]; then
   if [ -e /usr/local/jvo/headas ]; then
      export HEADAS=/usr/local/jvo/headas/x86_64
   elif [ -e /usr/local/headas ]; then
      export HEADAS=/usr/local/headas/x86_64
   fi
fi

#
# java
#
if [ -z "$JAVA_HOME" ]; then
   export JAVA_HOME=/usr/local/jdk
fi

#
# ant
#
if [ -z "$ANT_HOME" ];  then
   export ANT_HOME=/usr/local/ant
fi

#
# root
#
if [ -z "$ROOTSYS" ];  then
   export ROOTSYS=/usr/local/root
fi

#
# PATH
#
p="/bin /usr/bin /usr/X11R6/bin /usr/local/bin"
p="$p ${JAVA_HOME}/bin"
p="$p ${ANT_HOME}/bin"
p="$p ${JVO_TOOLS}/bin"

for d in $p; do
   pattern="(:${d}:|^${d}:|:${d}"'$'"|^${d}"'$'")"
   if ! echo $PATH | egrep -s $pattern >& /dev/null; then
      export PATH=${d}:${PATH}
   fi
done

#
#
#
if [ -e $HEADAS/headas-init.sh ]; then
   . $HEADAS/headas-init.sh
fi

#
# CLASSPATH
#
export CLASSPATH="${JAVA_HOME}/lib/tools.jar"


#
# LD_LIBRARY_PATH
#
p="/usr/local/lib ${ROOTSYS}/lib/root"
for c in $p; do
   pattern="(:${d}:|^${d}:|:${d}"'$'"|^${d}"'$'")"
   if ! echo $LD_LIBRARY_PATH | egrep -s $pattern  >& /dev/null; then
      if [ -z "$LD_LIBRARY_PATH" ]; then
         export LD_LIBRARY_PATH=${c}
      else
         export LD_LIBRARY_PATH=${c}:${LD_LIBRARY_PATH}
      fi
   fi
done

