#!/bin/bash

#
# 1. 
#
echo "# step 1"
agn_ra=$1
agn_dec=$2
agn_z=$3
wdir=$4

#
# 2. ȥǥ쥯ȥ
#
echo "# step 2"
mkdir $wdir
cp plot-dist-sample.C ${wdir}
cd $wdir

# 
# 3. UKIDSS ǡ
#
echo "# step 3"
fn_jvoql=search-ukidss.sql
echo "SELECT  ID, SOURCE_ID, RA2000, DE2000, MAG_K, SURVEY, kppErrBits" > $fn_jvoql
echo "FROM    ivo://jvo/ukidss:catalog_dr7 AS t" >> $fn_jvoql
echo "WHERE   REGION('CIRCLE $agn_ra $agn_dec 0.14')" >> $fn_jvoql
echo "        AND (mergedClass = 1 OR mergedClass = -3)" >> $fn_jvoql
echo "        AND MAG_K > 0" >> $fn_jvoql
echo "        AND survey = 'las'" >> $fn_jvoql
echo "        AND kppErrBits <= 255" >> $fn_jvoql
fn_vot=ukidss.xml
fn_csv=ukidss.csv
jc search -i ${fn_jvoql} -o ${fn_vot}
jc select -F, -o ${fn_csv} ${fn_vot}

#
# 3b. RA/Dec/mag ȴФ
#
echo "# step 3b"
cat ${fn_csv} | grep -v "#" | awk -F, '{if($5>0&&$7<=255) print $3,$4,$5}' > radecmag.dat
cat ${fn_csv} | grep -v "#" | awk -F, '{if($5>0&&$7<=255) print $3,$4}' > radec.dat


#
# 4. ߴΰͭ
#
echo "# step 4"
step=$(cosmic-distance -z ${agn_z} --length 0.1 | grep "separation angle" | awk '{print $4}')
args="-r ${agn_ra} -d ${agn_dec} --size ${step} --mask-rmax 4.0"
agn-catalog-coverage ${args} < radec.dat > earea.dat

#
# 5. ̩ʬ
#
echo "# step 5"
args="-r ${agn_ra} -d ${agn_dec} --dth ${step} --earea earea.dat -c radec.dat"
args="${args} --mask-rad 4.0 -z ${agn_z}"
agn-catalog-density ${args} > hist.dat

#
# 6. ץå
#
echo "# step 6"
th_1Mpc=$(cosmic-distance -z ${agn_z} --length 1 | grep "separation angle" | awk '{print $4/60/60}')
root -b -l -q "plot-dist-sample.C($agn_ra, $agn_dec, 0.14, ${th_1Mpc})"

#
# 7. ޥե
#
echo "# step 7"
fn_sum=summary.dat
echo "RA:       $agn_ra"  > $fn_sum
echo "DEC:      $agn_dec" >> $fn_sum
echo "REDSHIFT: $agn_z"   >> $fn_sum
echo "BAND:     K"        >> $fn_sum

exit 0
