void plot_dist_sample(double ra, double dec, double rad, double rad1Mpc) 
{
    //
    //
    //
    gROOT->SetStyle("Plain");     // ɽ off
    gStyle->SetOptTitle(kFALSE);  // ȥä
    gStyle->SetOptStat(kFALSE);   // ׾ä

    TCanvas* c1 = new TCanvas("c1", "c1", 300, 600);
    c1->Divide(1,2);

    c1->cd(1);
    plot_objects(ra, dec, rad, rad1Mpc);

    c1->cd(2);
    plot_density();
    gStyle->SetPaperSize(10,13);
    c1->Print("plot-dist.eps");
}


/**
 *
 */
void plot_objects(double ra, double dec, double rad, double rad1Mpc)
{
    //
    // 
    //
    Double_t x, y;
    double xmin, xmin, ymin, ymax;
    double dy, dx;

    string buf;
    TNtuple* nt = new TNtuple("object", "object", "x:y");
    
    dx = rad / cos(dec/180.*3.141592654);
    dy = rad;
    xmin = ra - dx;
    xmax = ra + dx;
    ymin = dec - dy;
    ymax = dec + dy;

    //
    // ǡ
    //
    ifstream data("radec.dat");
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>x>>y; 
        nt->Fill(x, y);
    }
    data.close();

    gStyle->SetNdivisions(505, "X");
    gStyle->SetNdivisions(505, "Y");


    //
    // XY ɽϰϤꤹ뤿ζҥȥ
    //
    printf("%f %f %f %f\n", xmin, xmax, ymin, ymax);

    TH1F *waku = new TH1F("waku", "title", 2, xmin, xmax);
    waku->SetMinimum(ymin);
    waku->SetMaximum(ymax);
    waku->Draw();
    waku->GetXaxis()->SetTitle("RA");
    waku->GetYaxis()->SetTitle("Dec");

    //
    // ϰϡʱߡ
    //
    TEllipse *region = new TEllipse(ra, dec, dx, dy);
    region->Draw("same");

    //
    // 5 Mpc
    //
    if( (rad1Mpc * 5) < rad) {
        dx = 5*rad1Mpc / cos(dec/180.*3.141592654);
        dy = 5*rad1Mpc;
        TEllipse *region = new TEllipse(ra, dec, dx, dy);
        region->Draw("same");
    }


    //
    // 3 Mpc
    //
    if(rad1Mpc * 3 < rad) {
        dx = 3 * rad1Mpc / cos(dec/180.*3.141592654);
        dy = 3 * rad1Mpc;
        TEllipse *region = new TEllipse(ra, dec, dx, dy);
        region->SetLineStyle(2);
        region->Draw("same");
    }

    //
    // 2 Mpc
    //
    if(rad1Mpc * 2 < rad) {
        dx = 2 * rad1Mpc / cos(dec/180.*3.141592654);
        dy = 2 * rad1Mpc;
        TEllipse *region = new TEllipse(ra, dec, dx, dy);
        region->SetLineStyle(2);
        region->Draw("same");
    }

    //
    // 1 Mpc
    //
    if(rad1Mpc < rad) {
        dx = rad1Mpc / cos(dec/180.*3.141592654);
        dy = rad1Mpc;
        TEllipse *region = new TEllipse(ra, dec, dx, dy);
        region->SetLineStyle(2);
        region->Draw("same");
    }

    //
    // ץå
    //
    nt->SetMarkerStyle(20);       // ޡ
    nt->SetMarkerColor(2);        // ޡο
    nt->SetMarkerSize(0.4);       // ޡ
    nt->Draw("y:x", "", "same");


}

/**
 *
 */
void plot_density()
{
    double x[1000], y[1000], sig[1000], erx[1000];
    double dummy;
    ifstream data("hist.dat");
    int ind=0;
    int num=0, count=0;
    string buf;
    //
    //
    //
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>x[ind]>>count>>dummy>>dummy>>y[ind]>>sig[ind]; 
        erx[ind] = 0;

        ind++;
        if(count > 0) {
            num = ind;
        }
        if(ind >= 1000) {
            break;
        }
    }
    data.close();
    //
    //
    //
//  TF1 *func = new TF1("func", func_cc, 0.01, 3, 2);

//    func->SetParLimits(0, 1, 120.0);
//    func->SetParLimits(1, 5.0, 10.0);
//    func->SetLineColor(1);
//    func->SetLineWidth(1);
//
//  func->SetParameters(10.0, 0.0);
//  func->Draw();
//


    graph = new TGraphErrors(num, x, y, erx, sig);
//  graph->Fit(func, "", "", 0.0, 3.0);

    graph->SetLineColor(1);
    graph->SetLineWidth(1);
    graph->SetMarkerColor(1);
    graph->SetMarkerSize(1.);
    graph->SetMarkerStyle(20);

    graph->SetTitle("");
    graph->GetXaxis()->SetTitle("distance (Mpc)");
    graph->GetYaxis()->SetTitle("density (Mpc-3)");

    graph->Draw("AP");
    
}
