#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <math.h>
#include <string.h>
#include <time.h>

#include "opt.h"
#include "astro-lib.h"

//
// B,V,R,I,i,z,J,H,K
//
//#define NUM_BAND 9
#define NBIN_EAREA 60

//double a;

double mask_rad = 4.0; // arcsec
double qso_ra;
double qso_dec;
double qso_z;
double qso_distance; // Luminosity Distance Mpc

double step_dr = -1;  // Mpc
double step_dth = -1;  // arcsec

double mag_cut = 99;

char *fn_cat;
char *fn_earea;
char *band_name;



//----------------

int num;
double *ra;
double *dec;
double *mag;

double r_low[NBIN_EAREA];
double r_upp[NBIN_EAREA];
double r_ave[NBIN_EAREA];

int count[NBIN_EAREA];

double hist[NBIN_EAREA];
double area[NBIN_EAREA];
double bad_frac[NBIN_EAREA];

void init();

void read_catalog();
void read_earea_file();

void cal_area();
void cal_norm_hist();
double radec2dist(double obj_ra, double obj_dec);

/**
 *
 */
int main(int argc, char *argv[])
{
    optUsage("agn-catalog-density");

    optrega(&qso_ra, OPT_DOUBLE, 'r', "ra", "RA of QSO [REQ]");
    optrega(&qso_dec, OPT_DOUBLE, 'd', "dec", "Dec of QSO [REQ]");
    optrega(&qso_z, OPT_DOUBLE, 'z', "redshift", "redshift of QSO [REQ]");
    optrega(&fn_cat, OPT_VSTRING, 'c', "cat", "file name of a merged catalog [REQ]");
    optrega(&fn_earea, OPT_VSTRING, 'e', "earea", "effective area file for B band [REQ]");
    optrega(&step_dth, OPT_DOUBLE, '\0', "dth", "bin width [arcsec]");
    optrega(&step_dr, OPT_DOUBLE, '\0', "dr",  "bin width [Mpc]");
    optrega(&mask_rad, OPT_DOUBLE, 'm', "mask-rad", "mask region radius (arcsec) (default=4.0)");

    //
    //
    //
    opt(&argc, &argv);

    //
    // qso_distance 
    //
    init();
    //
    //
    //
    read_catalog();
    //
    //
    //
    read_earea_file();
    //
    // r_low[], r_upp[], area[] η׻
    //
    cal_area();
    //
    //
    //
    cal_norm_hist();
    
    exit(0);
}

/**
 *
 */
void init()
{
    int j;
    double theta, qso_distance2;
    //
    //
    //
    for(j = 0; j < NBIN_EAREA; j++) {
	hist[j] = 0;
	count[j] = 0;
	area[j] = 0;
	r_low[j] = 0;
	r_upp[j] = 0;
        bad_frac[j] = 1.0;
    }

    qso_distance = get_luminocity_distance(Z, qso_z);
    qso_distance2 = get_comoving_distance(Z, qso_z);

    if(step_dth > 0) {
        theta = step_dth / 60. / 60. / 180. * PI;
        step_dr = qso_distance * theta / pow((1 + qso_z), 1.0);
    } else if(step_dr > 0) {
        theta = step_dr / qso_distance * pow((1 + qso_z), 1.0);
        step_dth = theta / PI * 180 * 60 * 60;
    }

    printf("# agn_ra       = %lf [deg]\n", qso_ra);
    printf("# agn_dec      = %lf [deg]\n", qso_dec);
    printf("# agn_z        = %lf \n", qso_z);
    printf("# agn_dist(Dl) = %lf [Mpc] (luminosity distance)\n", qso_distance);
    printf("# agn_dist(Dc) = %lf [Mpc] (comoving distance)\n", qso_distance2);
    printf("# step_dr      = %lf [Mpc]\n", step_dr);
    printf("# step_dth     = %lf [arcsec]\n", step_dth);
    printf("# mask_rad     = %lf [arcsec]\n", mask_rad);
}

/**
 *
 */
void read_catalog() {
    int i;
    FILE *fp;
    char line[1000];
    int max = 10000;
    int step = 1000;
    //double mag_cor = 0;
    
    fp = fopen(fn_cat, "r");

    //
    //
    //
    ra = (double *) malloc(sizeof(double) * max);
    dec = (double *) malloc(sizeof(double) * max);
    mag = (double *) malloc(sizeof(double) * max);
    //
    //
    //
    i = 0;
    while(1) {
	//
	//
	//
	fgets(line, 1000, fp);
	if(feof(fp) == 1) {
	    break;
	}

	if(line[0] == '#') {
	    continue;
	}
        //
        //
        //
	//sscanf(line, "%lf %lf %lf", &ra[i], &dec[i], &mag[i]);
	sscanf(line, "%lf %lf", &ra[i], &dec[i]);
	i++;
	if(i >= max) {
	    max += step;
	    ra = (double *) realloc(ra, sizeof(double) * max);
	    dec = (double *) realloc(dec, sizeof(double) * max);
            mag = (double *) realloc(mag, sizeof(double) * max);
	}
    }
    num = i;
}

/**
 *
 */
void cal_area()
{
    int i;
    double theta, min_rad_Mpc, area_mask;
    //
    // arcsec --> radian
    //
    theta = mask_rad / 60. / 60. / 180. * PI;
    //
    // proper distance (Mpc)
    //
    //min_rad_Mpc = qso_distance * theta / pow((1 + qso_z), 2.0);
    //
    // comoving distance (Mpc)
    //
    min_rad_Mpc = qso_distance * theta / pow((1 + qso_z), 1.0);
    //
    // printf("# min_rad_Mpc  (cal_area)= %lf\n", min_rad_Mpc);
    //
    for(i = 0; i < NBIN_EAREA; i++) {
	r_low[i] = i * step_dr;
	r_upp[i] = (i + 1) * step_dr;
	r_ave[i] = (i + 0.5) * step_dr;
	//
	// ޥꥢη׻
	//
	area_mask = 0;
	if(r_low[i] < min_rad_Mpc) {
	    if(r_upp[i] >= min_rad_Mpc) {
		area_mask = PI * (min_rad_Mpc * min_rad_Mpc - r_low[i] * r_low[i]);
		r_ave[i] = (min_rad_Mpc + r_upp[i]) * 0.5;
	    } else {
		area_mask = PI * (r_upp[i] * r_upp[i] - r_low[i] * r_low[i]);
	    }
	}
	area[i] = PI * (r_upp[i] * r_upp[i] - r_low[i] * r_low[i]) - area_mask;
    }
}

/**
 *
 */
void read_earea_file() {
    int i;
    char line[1000];
    FILE *fp;
    //
    //
    //
    //printf("# %s\n", fn_earea);
    fp = fopen(fn_earea, "r");
    //
    //
    //
    i = 0;
    while(1) {
	//
	// 
	//
	fgets(line, 1000, fp);
	if(feof(fp) == 1) {
	    break;
	}
	if(line[0] == '#') {
	    continue;
	}
	sscanf(line, "%*d %*f %*f %lf", &bad_frac[i]);
	i++;
	if(i >= NBIN_EAREA) {
	    break;
	}
    }
	
}

/**
 *
 */
void cal_norm_hist()
{
    int i;
    int ind;
    double d;
    double min;
    double r; // Mpc
    double den; // Mpc-2
    double err; // Mpc-2
    double theta, min_rad_Mpc;
    double cor;
    
    //
    // arcsec --> radian
    //
    theta = mask_rad / 60. / 60. / 180. * PI;
    //
    // proper distance (Mpc)
    //
    //min_rad_Mpc = qso_distance * theta / pow((1 + qso_z), 2.0);
    //
    // comoving distance (Mpc)
    //
    min_rad_Mpc = qso_distance * theta / pow((1 + qso_z), 1.0);

    //printf("# min_rad = %lf\n", min_rad);
    printf("# min_rad_Mpc  = %lf\n", min_rad_Mpc);
    
    //
    //
    //
    for(i = 0; i < num; i++) {
	//
	// Mpc
	//
	d = radec2dist(ra[i], dec[i]);
        //
        // printf("# %lf %lf %lf\n", ra[i], dec[i], d);
	//
	//  ޥΰϥå
	//
	if(d < min_rad_Mpc) {
	    continue;
	}
	ind = (int) (d / step_dr);
	if(ind >= NBIN_EAREA || ind < 0) {
	    continue;
	}
	//
	// ޥΰǾ
	//
	min = 100;
        //if(bad_frac[ind] < 0.9 && mag[i] > 10 && bad_frac[ind] < min) {
        if(bad_frac[ind] < 0.9 && bad_frac[ind] < min) {
            min = bad_frac[ind];
        }
	//
	//
	// printf("# %d %lf\n", i, min);
	//
        //
	if(min < 0.9) {
	    hist[ind] += (1 / (double) (1 - min));
	    count[ind]++;
	}
    }

    //
    //
    //
    printf("#\n");
    printf("# r(Mpc), hist[i], area[i](Mpc2), den(Mpc-2), err(Mpc-2), bad_frac\n");
    printf("#\n");
    for(i = 0; i < NBIN_EAREA; i++) {
	r = r_ave[i];
	if(area[i] > 0) {
	    den = hist[i] / area[i];
	} else {
	    den = 0;
	}
	if(count[i] > 0) {
	    cor = hist[i] / (double) count[i];
	} else {
	    cor = 1;
	}
	if(hist[i] > 0 && area[i] > 0) {
	    err = sqrt((double) count[i]) * cor / area[i];
	} else {
	    err = 0;
	}
	printf("%lf %d %lf %lf %lf %lf %lf\n", r, count[i], hist[i], area[i], 
               den, err, bad_frac[i]);
    }
}

/**
 *
 */
double radec2dist(double obj_ra, double obj_dec)
{
    double d, theta, distance;
    //
    // d: degree
    // theta: radian
    //
    d = angdiff(qso_ra, qso_dec, obj_ra, obj_dec);
    theta = d / 180. * PI;
    //
    // proper
    //
    // distance = qso_distance * theta / pow((1 + qso_z), 2.0);
    //
    // comoving
    //
    distance = qso_distance * theta / pow((1 + qso_z), 1.0);
    
    return distance;
}
