#include <stdlib.h>
#include <math.h>

#define PI 3.141592653589793238 
static int sw;

unsigned short *put_seed2(unsigned short seed_init[3])
{
  return seed48(seed_init);
}

double rnunf(void)
{
  return drand48();
}

double rnnof(void)
{
  static double r1, r2, s;

  if(sw == 0) {
    sw = 1;
    do {
      r1 = 2 * rnunf() - 1;
      r2 = 2 * rnunf() - 1;
      s  = r1 * r1 + r2 * r2;
    } while (s > 1 || s == 0);
    s = sqrt(-2 * log(s) / s);
    return r1 * s;
  } else { 
    sw = 0;
    return r2 * s;
  }
}

double rnnof2()
{
  double t, u, tmp;

  tmp = rnunf();
  t   = sqrt(-2 * log(1 - tmp));
  u   = 2 * PI * rnunf();

  return t * cos(u);
}

int rnpoi(double lambda)
{
  int k;

  lambda = exp(lambda) * rnunf();
  k = 0;
  while(lambda > 1) {
    lambda *= rnunf();  k++;
  }
  return k;
}

double rngam1(int n)
{
  int i;
  int m;
  double x, y;
  double v1, v2;
  double s, e;
  
  if(n < 1) {
    printf(" <rngam1> error ! \n");
    exit(0);
  }

  if(n < 6) {
    x = 1.;
    for(i = 0; i < n; i++) x *= rnunf();
    x = -log(x);
  } else {

  Skip:;
    v1 = 2. * rnunf() - 1.;
    v2 = 2. * rnunf() - 1.;
    if(v1 * v1 + v2 * v2 > 1.) goto Skip;
    y = v2 / v1;
    m = n - 1;
    s = sqrt((double)(2 * m) + 1.0);
    x = s * y + m;
    if(x <= 0) goto Skip;
    e = (1. + y * y) * exp((double) m * log(x / (double) m) - s * y);
  }

  return x;
}
