/* $Id: opt.h,v 1.1.1.1 2006/09/08 10:07:43 fjvo03 Exp $ */
/* opt.h */
/*
	User Include File for options package
*/

#ifndef _OPT_H
#define	_OPT_H 	/* Signal that this header file has been included */

/***
 * Enable linking with C++
 ***/
#ifdef __cplusplus
extern "C"
{
#endif



typedef enum    {
    OPT_NUL,
    OPT_INT,        OPT_SHORT,      OPT_LONG,       OPT_CHAR,
    OPT_UINT,       OPT_USHORT,     OPT_ULONG,      OPT_UCHAR,
    OPT_FLOAT,      OPT_DOUBLE,
    OPT_FLAG,       OPT_NEGFLAG,    OPT_ABSFLAG,    OPT_ABSNEGFLAG,
    OPT_INTLEVEL,       
    OPT_STRING,     OPT_UNDELIM,
    OPT_CSTRING,    OPT_UNDELIMC,
    /* now deprecated */
    OPT_UNSINT,     OPT_VSTRING,    OPT_UNDELIMV
} opt_TYPE;

/* OPT_PFI is the ever popular: Pointer to Function returning an Integer */
typedef	int (*OPT_PFI)(void);
typedef int (*OPT_HOOK)(void *);
typedef	int (*OPT_PFI_ARG)(int,char**);

#define	OPT_EXT	".opt"	  /* standard options file extension */
#define OPT_MAXSTRLEN 80  /* CSTRING's should be no longer than this */

#define OPT_TRUE 1
#define OPT_FALSE 0

/* Return values from hook functions */
#define OPT_OK    0
#define OPT_ERROR 1
#define OPT_ABORT 2
#define OPT_QUIT  3
#define OPT_EXIT  4

/* opt(&argc,&argv) is the main function call that does all the work.
 * it processes the options on the command line, setting variables,
 * calling hooks, etc. 
 */

extern void opt(int *,char ***);

/* But before opt() can be called, variables/hooks/etc must be
 * registered.  Various ways are provided to register variables; one
 * identifies the variable by its (void *) pointer.  To register a
 * variable, an opt_TYPE must be specified, and either a character or
 * a string name (or both), and optionally a brief description.
 */
/*  optrega: "all"
 *  optreg:  standard
 *  optregc: just sets character name
 *  optregs: just sets string name
 *  optregcb: sets character name and brief description
 *  optregsb: sets string name and brief description
 *  optexec: registers an 'exec function' (somthing that is run, then exits)
 */

/*    ARGUMENT LIST:  &var   OPT_INT   'c'   "name"  "Descript" */
extern int optrega(  void *, opt_TYPE, char,  char *, char * );
extern int optreg(   void *, opt_TYPE, char,          char * );
extern int optregc(  void *, opt_TYPE, char                  );
extern int optregcb( void *, opt_TYPE, char,          char * );
extern int optregs(  void *, opt_TYPE,        char *         );
extern int optregsb( void *, opt_TYPE,        char *, char * );
/*    ARGUMENT LIST:  &var   OPT_INT   'c'   "name"  "Descript" */

/*    ARGUMENTS:    "name"  hook "Descript" */
extern int optexec( char *, OPT_HOOK, char * );

/* Using the following routines, one can specify features (such as
 * char, longname, descript) of the variable that were left out in the
 * registration process, or one can add features (such as help, hook,
 * exec) that the registration routines do not permit.
 */
/* These functions use &var to identify which option */
extern void optchar(     void *,char);
extern void optlongname( void *,char *);
extern void optdescript( void *,char *);
extern void opthelp(     void *,char *);
extern void opthook(     void *,OPT_HOOK);
/* These functions use option number to identify which option */
extern void optchar_n(     int,char);
extern void optlongname_n( int,char *);
extern void optdescript_n( int,char *);
extern void opthelp_n(     int,char *);
extern void opthook_n(     int,OPT_HOOK);

/* optinvoked(&var) returns the number of times the option was invoked
 * on the command line.  This function is not used in the registering
 * stage, but is used during execution of the code to see whether or
 * not a value was actually set (or if it's just using the default).
 */
extern int  optinvoked(void *);

/* The following routines are used to set features (such as usage),
 * which are not specific to single variables, but apply to the whole
 * program.  In general, I try to use the convention optUpperCase()
 * for the registration of these more global features, while
 * optlowercase() refers to functions that apply to a specific
 * registered variable.
 */
extern void optUsage(char *);
extern void optTitle(char *);
extern void optEnvVarName(char *);
extern void optDefaultString(char *);
extern void optDefaultFile(char *);

extern void optAdditionalUsage(OPT_PFI);
extern void optQuit(OPT_PFI);
extern void optRun(OPT_PFI);
extern void optMain(OPT_PFI_ARG);
extern void optExitNumber(int);

/* The following prototypes arguably belong in opt_p.h because it is
 * not clear that the functions would ever be used in a program that
 * uses opt.  Certainly, opt itself makes great use of these, behind
 * the scenes.
 */
extern void optAbortRun(void);
extern  int optBeginRun(OPT_PFI);
extern void optAbortMain(void);
extern  int optBeginMain(OPT_PFI_ARG, int, char **);

extern void opt_message(char *);
extern void opt_warning(char *);
extern void opt_fatal(char *);

/* The following prototypes are deprecated; they are defined for
 * compatibility with versions of opt prior to v3.0, but they are not
 * recommended.
 */
extern  int getopts(int,char **);
#define	optregister(val,typ,c,str) optreg(&val,typ,c,str)
#define optrunset(r) do {int r(); opt_run_set(r);} while(0)

/***
 * Enable linking with C++
 ***/
#ifdef __cplusplus
}
#endif

#endif /* _OPT_H */


