/**
 *
 */
void fit_density(double rho0, double xmax)
{
    double x[1000], y[1000], sig[1000], erx[1000];
    double dummy;
    ifstream data("hist_add.dat");
    int ind=0;
    int num=0, count=0;
    string buf;
    //
    //
    //
    while (data && getline(data, buf)) {
        if(buf.at(0) == '#') {
            continue;
        }
        istrstream istr(buf.data());
        istr>>dummy>>x[ind]>>count>>dummy>>dummy>>y[ind]>>sig[ind]; 
        erx[ind] = 0;
        if(count > 0) {
            num = ind;
        }
        if(x[ind] > xmax) {
            break;
        }
        ind++;
        if(ind >= 1000) {
            break;
        }
    }
    data.close();

    printf("num = %d\n", num);
    //
    //
    //
    TF1 *func = new TF1("func", func_cc, 0.01, 10, 3);
    func->SetParLimits(0, 1, 120.0);
    func->SetParLimits(1, 5.0, 1000.0);
//  func->FixParameter(0, 10);
    func->FixParameter(2, rho0);
    func->SetLineColor(1);
    func->SetLineWidth(1);
    func->SetParameters(10.0, 0.0, rho0);
//  func->Draw();

    //
    //
    //
    graph = new TGraphErrors(num, x, y, erx, sig);
    graph->Fit(func, "", "", 0.0, xmax);

    graph->SetLineColor(1);
    graph->SetLineWidth(1);
    graph->SetMarkerColor(1);
    graph->SetMarkerSize(1.);
    graph->SetMarkerStyle(20);

    graph->SetTitle("");
    graph->GetXaxis()->SetTitle("distance (Mpc)");
    graph->GetYaxis()->SetTitle("density (Mpc-3)");

    graph->Draw("AP");
//
//   func->Draw("same");
//
}


/**
 *
 */
Double_t func_cc(Double_t *x, Double_t *par)
{
    double r0, g, bg0, rho0, c;
    //
    // x is the pointer to the array which contains x[0],x[1],x[2],...
    // par is the pointer to the array which contains p[0],p[1],p[2],...  
    //
    r0 = par[0];
    bg0 = par[1];
    rho0 = par[2];
    g = 1.8;
    //
    //
    //
    c = gamma(0.5) * gamma((g - 1) / 2) / gamma(g / 2);
    return x[0] * (r0 / x[0])**g * c * rho0 + bg0;
}


//
//
//
#define PI      3.14159265358979324  /* $\pi$ */
#define LOG_2PI 1.83787706640934548  /* $\log 2\pi$ */
#define N       8
#define B0  1                 /* ʲBernoulli */
#define B1  (-1.0 / 2.0)
#define B2  ( 1.0 / 6.0)
#define B4  (-1.0 / 30.0)
#define B6  ( 1.0 / 42.0)
#define B8  (-1.0 / 30.0)
#define B10 ( 5.0 / 66.0)
#define B12 (-691.0 / 2730.0)
#define B14 ( 7.0 / 6.0)
#define B16 (-3617.0 / 510.0)

/**
 *
 */
double loggamma(double x)  /* ޴ؿп */
{
    double v, w;

    v = 1;
    while (x < N) {  v *= x;  x++;  }
    w = 1 / (x * x);
    return ((((((((B16 / (16 * 15))  * w + (B14 / (14 * 13))) * w
                + (B12 / (12 * 11))) * w + (B10 / (10 *  9))) * w
                + (B8  / ( 8 *  7))) * w + (B6  / ( 6 *  5))) * w
                + (B4  / ( 4 *  3))) * w + (B2  / ( 2 *  1))) / x
                + 0.5 * LOG_2PI - log(v) - x + (x - 0.5) * log(x);
}


/**
 *
 */
double gamma(double x)  /* ޴ؿ */
{
    if (x < 0) {
       return PI / (sin(PI * x) * exp(loggamma(1 - x)));
    } else {
       return exp(loggamma(x));
    }
}
