#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>

#include "opt.h"
#include "astro-lib.h"
#include "qsort2.h"

#define N_TH 100
#define N_PH 10000
#define PI 3.141592654

typedef struct {
    int num;
    double *ph_start;
    double *ph_end;
    double *density; // [/deg]
} Regions;


//
// »ΰȽǤ뤿ɬפʥǡδͤκǾ
//
int g_nmin1 = 10;
//
// »ΰȽǤɬפǡʱߴǡ
//
int g_nmin2 = 100;
//
//
//
double g_cut_sigma = 3.0;



double g_center_ra;
double g_center_dec;

int g_lin = 0;
int g_log = 0;
int g_rr = 0;

double g_bin_size = 10.;
double g_bin_logsize = 0.2;
double g_bin_r2size = 0.2;

double bin_min = 0;
double bin_max = 2000;

double g_mask_rmax = 4.0; // arcsec 
//double ave_den = -1;

//
// init() ꤵ
//
double g_rot[3][3];

//
// ߴĤȾ (g_r0: , g_r1: ¦, g_r2: ¦)
// init() ꤵ
//
double g_r0[N_TH];
double g_r1[N_TH];
double g_r2[N_TH];

//
// read() ꤵ
// ߴ ph ͤݻ
//
int g_num[N_TH];
double g_ph[N_TH][N_PH];

//
//
//
int g_from[N_TH];
int g_to[N_TH];
double g_dead_frac[N_TH];

void init();
void read();
void cal_dead();
void output();
void do_mask_overlap(int num, int stt1, int end1, int step, int total, int *start, int *diff_mask);
void do_mask_for_ph(int total, int *ph_mask, int start, int end, int mask_value);
void create_mask(int num, double cut, int *start, int step, int total, double *diff, 
                 int *index, int *diff_mask, int *ph_mask);
double cal_dead_binning(int from, int to, int step, double den, double den_sig);
void cal_stat(int num, double *diff, double diff_cut, int *mask, double stat[2]);
void rotate(double mat[3][3],double x, double y, double z,double *x2, double *y2, double *z2);
	    
double cal_density(int total, double *ph, int *ph_mask);
Regions cal_low_density_region(int total, double *ph, int *ph_mask);

double cal_dead_sum(int total, double dens_ave, Regions regions);

/**
 *
 */
int main(int argc, char *argv[])
{
    optUsage("[OPTIONS]");

    optrega(&g_center_ra, OPT_DOUBLE, 'r', "ra", "center ra");
    optrega(&g_center_dec, OPT_DOUBLE, 'd', "dec", "center dec");

    //optrega(&bin_min, OPT_DOUBLE, '\0', "min", "bin minimum");
    //optrega(&bin_max, OPT_DOUBLE, '\0', "max", "bin maximum");

    optrega(&g_bin_size,    OPT_DOUBLE, '\0', "size",    "bin size (arcsec)");
    optrega(&g_bin_logsize, OPT_DOUBLE, '\0', "logsize", "bin size in log10(arcsec)");
    optrega(&g_bin_r2size,  OPT_DOUBLE, '\0', "r2size",      "bin size in dr^2 (arcsec^2)");

    optrega(&g_lin, OPT_ABSFLAG, '\0', "lin", "distance bin is in lin scale (default)");
    optrega(&g_log, OPT_ABSFLAG, '\0', "log", "distance bin is in log scale");
    optrega(&g_rr,  OPT_ABSFLAG, '\0', "r2",  "distance bin is in dr^2");

    optrega(&g_mask_rmax, OPT_DOUBLE, '\0', "mask-rmax", "mask size (arcsec)");
    optrega(&g_nmin1, OPT_DOUBLE, '\0', "num-min1", "minimum number for estimating bad fraction");
    optrega(&g_nmin2, OPT_DOUBLE, '\0', "num-min2", "minimum number for estimating bad fraction");
    optrega(&g_cut_sigma, OPT_DOUBLE, '\0', "cut-sigma", "bad region threshold (sigma)");

    //optrega(&g_ave_den, OPT_DOUBLE, '\0', "ave-dens", "average density (arcmin-2)");

    opt(&argc, &argv);

    //
    // ž rot ν
    //
    init();
    
    //
    // ɸǡɤ߹ ph_mem[][]  num[] ͤ
    //
    read();

    //
    // g_dead_frac[] ׻
    //
    cal_dead();

    //
    // ̤Ϥ
    //
    output();

    exit(0);
}

/**
 *
 */
void init() 
{
    int i;
    double th, ph;

    //
    // degree
    //
    th = (90 - g_center_dec) / 180. * PI;
    ph = g_center_ra / 180. * PI;
    g_rot[0][0] = cos(th) * cos(ph);
    g_rot[0][1] = cos(th) * sin(ph);
    g_rot[0][2] = -sin(th);
    g_rot[1][0] = -sin(ph);
    g_rot[1][1] = cos(ph);
    g_rot[1][2] = 0;
    g_rot[2][0] = sin(th) * cos(ph);
    g_rot[2][1] = sin(th) * sin(ph);
    g_rot[2][2] = cos(th);
    //
    //
    //
    for(i = 0; i < N_TH; i++) {
        if(g_log == 1) {
            g_r0[i] = pow(10., g_bin_logsize * (i + 0.5));
            g_r1[i] = pow(10., g_bin_logsize * i);
            g_r2[i] = pow(10., g_bin_logsize * (i + 1));
            
        } else if(g_rr == 1) {
            g_r0[i] = sqrt(g_bin_r2size * (i + 0.5));
            g_r1[i] = sqrt(g_bin_r2size * i);
            g_r2[i] = sqrt(g_bin_r2size * (i + 1));
            
        } else {
            g_r0[i] = g_bin_size * (i + 0.5);
            g_r1[i] = g_bin_size * i;
            g_r2[i] = g_bin_size * (i + 1);
        }
    }
}

/**
 *
 */
void read() 
{
    int i;
    int ind_t;
    double ra, dec;
    double x, y, z, x2, y2, z2, t2, p2;
    //
    //
    //
    for(i = 0; i < N_TH; i++) {
	g_num[i] = 0;
    }

    //
    // ph_mem[][]  num[] 
    //
    while(feof(stdin) == 0) {
	fscanf(stdin, "%lf %lf", &ra, &dec);
	if(feof(stdin) == 1) {
            break;
        }
	//
	radec2xyz(ra, dec, &x, &y, &z);
	//
	rotate(g_rot, x, y, z, &x2, &y2, &z2);
	//
	xyz2tp(x2, y2, z2, &t2, &p2);

        //
        // arcsec Ѵ
        //
        t2 = t2 * 60 * 60;
        if(t2 < g_mask_rmax) {
            continue;
        }

        //
	// AGN Υ --> ҥȥ index
        //
        if(g_log == 1) {
            ind_t = (int) (log10(t2) / g_bin_logsize);
        } else if(g_rr == 1) {
            ind_t = (int) (t2 * t2 / g_bin_r2size);
        } else {
            ind_t = (int) (t2 / g_bin_size);
        }
        //
        //printf("# t2 = %lf, int_d = %d\n", t2, ind_t);
	//
	if(ind_t < N_TH) {
	    if(p2 <= 0) {
		p2 += 360;
	    }
	    g_ph[ind_t][g_num[ind_t]] = p2;
	    g_num[ind_t]++;
	}
    }
    
}

/**
 * g_dead_frac[] ׻
 */
void cal_dead()
{
    int i, j;
    int from, to, total;
    int step, step_max;
    int binning_max = 20;
    int s1_num;
    double area;
    double den, den_sig, nexp;
    double dfrac, dfrac_max;
    double s1_earea;

    //
    // ߴ dead ΰγ롣count = 0 ξϤȤФ
    //
    s1_num = 0;
    s1_earea = 0;

    for(i = 0; i < N_TH; i++) {
        from = i;
        to = i;
        total = g_num[i];
        //
        // nexp η׻
        //
        area = PI * (g_r2[i] * g_r2[i] - g_r1[i] * g_r1[i]);
        if(s1_earea > 0 && area > 0 && s1_num > 10000000) {
            den = s1_num / s1_earea;
            den_sig = sqrt(s1_num) / s1_earea;
            nexp = s1_num / s1_earea * area;
        } else {
            den = -1;
            den_sig = -1;
            nexp = total;
        }
        //
        // bin 
        // total : from  to ޤǤΥǡ
        // nexp  : from  to ޤǤΥǡδ 
        //         (s1_num, s1_earea ׻)
        //
        if(total < g_nmin2 || nexp < g_nmin1) {
            for(j = 1; j < binning_max; j ++) {
                if(i - j >= 0) {
                    total += g_num[i - j];
                    from = i - j;
                }
                if(i + j < N_TH) {
                    total += g_num[i + j];
                    to = i + j;
                }
                //
                // 礵줿ߴΰˤŷοδ : nexp
                //
                area = PI * (g_r2[to] * g_r2[to] - g_r1[from] * g_r1[from]);
                if(s1_earea > 0 && area > 0) {
                    nexp = s1_num / s1_earea * area;
                } else {
                    nexp = total;
                }
                if(total >= g_nmin2 && nexp >= g_nmin1) {
                    break;
                }
            }
        }
        //
        //
        //
        g_from[i] = from;
        g_to[i] = to;
        dfrac_max = -1;
        step_max = total / 10;
        for(step = 1; step <= step_max; step++) {
            dfrac = cal_dead_binning(from, to, step, den, den_sig);
            if(dfrac > dfrac_max) {
                dfrac_max = dfrac;
            }
        }

        area = PI * (g_r2[i] * g_r2[i] - g_r1[i] * g_r1[i]);

        //printf("# %d %lf %lf %d %lf %lf %lf %d %lf %lf %lf\n", 
        //i, g_r1[i], g_r2[i], g_num[i], 
        //den, den_sig, dfrac_max, 
        //s1_num, s1_earea, (double) s1_num / s1_earea,
        //g_num[i] / area);
            
        if(dfrac_max > 0) {
            g_dead_frac[i] = dfrac_max;
        } else {
            g_dead_frac[i] = 0;
        }

        if(g_num[i] >= g_nmin2) {
            s1_num += g_num[i];
            s1_earea += (area * (1 - dfrac_max));
        }
    }
    
}

/**
 *
 */
double cal_dead_binning(int from, int to, int step, double den, double den_sig) 
{
    int i, j, k;
    int imax;
    int total;
    int num;
    int offset, max;
    int *start, *index, *diff_mask, *ph_mask;
    double *ph;
    double ave, sig, nexp;
    double pre, *diff;
    double dead_sum, area;
    double diff_max, diff_cut;
    double stat[2];
    double dens_ave;
    Regions regions;

    //
    // from  to ޤǤαߴĤΥǡ
    //
    total = 0;
    for(i = from; i <= to; i++) {
        total += g_num[i];
    }
    //
    // ǡ g_nmin2 ʲξ dead_frac  -1 ֤
    //
    if(total < g_nmin2) {
        return -1;
    }
    //
    //
    //
    ph = (double *) calloc(total, sizeof(double));
    ph_mask = (int *) calloc(total, sizeof(int));
    k = 0;
    for(i = from; i <= to; i++) {
        for(j = 0; j < g_num[i]; j++) {
            ph[k] = g_ph[i][j];
            k++;
        }
    }

    //
    // phi ͤǥ
    //
    qsort2(total, ph);

    //
    // phi κΥǥʬ
    //
    max = 1000;
    diff = (double *) calloc(max, sizeof(double));
    start = (int *) calloc(max, sizeof(int));
    index = (int *) calloc(max, sizeof(int));
    diff_mask = (int *) calloc(max, sizeof(int));
    diff_max = -1;
    k = 0;
    for(offset = 0; offset < step; offset++) {
        for(i = offset; i < total; i += step) {
            j = i - step;
            if(j < 0) {
                j = j + total;
                pre = ph[j] - 360;
            } else {
                pre = ph[j];
            }

            if(k >= max) {
                max += 1000;
                diff = (double *) realloc(diff, sizeof(double) * max);
                start = (int *) realloc(start, sizeof(int) * max);
                index = (int *) realloc(index, sizeof(int) * max);
                diff_mask = (int *) realloc(diff_mask, sizeof(int) * max);
            }

            diff[k] = fabs(ph[i] - pre);
            start[k] = j;
            index[k] = k;
            diff_mask[k] = 0;
            k++;
        }
    }
    num = k;
    index_sort(num, diff, index);
    
    if(den > 0) {
        //
        // from  to ޤǤαߴĤѤ롣
        // Ѥˤͤ롣
        //
        area = PI * (g_r2[to] * g_r2[to] - g_r1[from] * g_r1[from]);
        nexp = den * area;
        ave = 360. / nexp * step;
        sig = 360. / (nexp * nexp) * sqrt(nexp) * step;

        //printf("# %d %lf %lf  %lf %lf\n", 
        //step, ave, sig,  
        //diff[index[num / 2]], diff[index[(int) (num * 0.84)]] - ave);
    } else {
        ave = diff[index[num / 2]];
        sig = diff[index[(int) (num * 0.84)]] - ave;
    }

    diff_max = diff[index[num -1]];

    //printf("# [0] ave=%lf sig=%lf diff_max=%lf dev_sig=%lf\n", 
    //ave, sig, diff_max, (diff_max - ave) / sig);

    //
    // diff ΤΤޤʿѤ 5 sigma ʾΤΤ
    // ʿͤʬ롣
    //
    if(1) {
        diff_cut = ave + g_cut_sigma * sig;
        diff_max = diff[index[num -1]];
        imax = start[index[num - 1]];
        //
        //printf("# diff_cut=%lf  diff_max=%lf\n", diff_cut, diff_max);
        //
        if(diff_max < diff_cut) {
            diff_cut = diff_max;
        }
        //
        // diff  diff_cut 礭ʤϰϤ mask 롣
        //
        //printf("# create_mask [0]\n");
        create_mask(num, diff_cut, start, step, total, diff, index, diff_mask, ph_mask);
        //
        // mask ΰơ̤׻
        //
        //printf("# cal_stat [0]\n");
        cal_stat(num, diff, diff_cut, diff_mask, stat);
        ave = stat[0];
        sig = stat[1];
        //printf("# [1] ave=%lf sig=%lf\n", ave, sig);

        //printf("# [1] from=%d to=%d step=%d ave=%lf sig=%lf diff_max=%lf dev_sig=%lf\n", 
        //from, to, step,
        //ave, sig, diff_max, (diff_max - ave) / sig);

        //
        // ave+5*sig ˵᤿ diff_cut 꾮 diff_cut 
        // ֤ͤmask Ʒ׻
        //
        if((ave + g_cut_sigma * sig) < diff_cut) {
            diff_cut = ave + g_cut_sigma * sig;
            create_mask(num, diff_cut, start, step, total, diff, index, diff_mask, ph_mask);
        }
    }
    
    //
    // ޥΰΥ꡼
    //
    regions = cal_low_density_region(total, ph, ph_mask);

    //
    // ʿѿ̩ [deg-1] ׻
    //
    dens_ave = cal_density(total, ph, ph_mask);

    //
    // ޥΰͭĹ [deg]
    //
    dead_sum = cal_dead_sum(total, dens_ave, regions);
    //printf("# dead_sum=%lf [deg]\n", dead_sum);

    free(ph);
    free(ph_mask);
    free(diff);
    free(start);
    free(index);
    free(diff_mask);
    free(regions.ph_start);
    free(regions.ph_end);
    free(regions.density);

    return dead_sum / 360;

}

/**
 *
 */
double cal_dead_sum(int total, double dens_ave, Regions regions) 
{
    int i;
    int num;
    double ph1, ph2;
    double dens, exp;
    double dead_sum;

    dead_sum = 0;
    for(i = 0; i < regions.num; i++) {
        ph1 = regions.ph_start[i];
        ph2 = regions.ph_end[i];
        dens = regions.density[i];
        if(ph1 > ph2) {
            ph1 -= 360;
        }
        exp = dens_ave * (ph2 - ph1);
        num = dens * (ph2 - ph1);

        if(exp - sqrt(exp) * 5 > num && dens_ave > 0) {
            dead_sum += ( (1 - dens / dens_ave) * (ph2 - ph1));
        }

            //printf("# [0] exp=%lf num=%d ph1=%lf ph2=%lf dead=%lf\n", exp, num, ph1, ph2, dead_sum);
        //} else {
        //printf("# [1] exp=%lf num=%d ph1=%lf ph2=%lf dead=%lf\n", exp, num, ph1, ph2, dead_sum);
        //}
    }
    
    return dead_sum;
}


/**
 *
 */
double cal_density(int total, double *ph, int *ph_mask) 
{
    int i;
    int num;
    double s;

    //
    //  mask ΰΥå
    //
    num = 0;
    s = 0;
    for(i = 0; i < total; i++) {
        if(ph_mask[i] != 0) {
            continue;
        }
        num++;
        if(i + 1 < total) {
            s += (ph[i + 1] - ph[i]);
        } else {
            s += ((360 - ph[i]) + ph[0]);
        }
    }

    if(s > 0) {
        return num / s;
    } else {
        return 0.0;
    }
}

/**
 *
 */
Regions cal_low_density_region(int total, double *ph, int *ph_mask)
{
    int i, j;
    int num, max;
    int ind1, ind2;
    int *stt, *end, *index;
    double ph1, ph2, *dens;
    Regions region;

    num = 0;
    max = 1000;
    stt = (int *) calloc(max, sizeof(int));
    end = (int *) calloc(max, sizeof(int));
    index = (int *) calloc(max, sizeof(int));
    dens = (double *) calloc(max, sizeof(double));

    //
    // mask ΰΥå
    //
    for(i = 0; i < total; i++) {
        if(ph_mask[i] == 0) {
            if(end[num] > 0) {
                num++;
            }
            continue;

        } else {
            if(end[num] == 0) {
                stt[num] = i;
            }
            end[num] = i + 1;
            if((i + 1) == total) {
                //
                // Ǹ
                //
                if(num > 0 && stt[0] == 0) {
                    stt[0] = stt[num];
                } else {
                    end[num] = 0;
                    num++;
                    if(num >= 1000) {
                        max += 1000;
                        stt = (int *) realloc(stt, sizeof(int) * max);
                        end = (int *) realloc(end, sizeof(int) * max);
                        index = (int *) realloc(index, sizeof(int) * max);
                        dens = (double *) realloc(dens, sizeof(double) * max);
                    }
                }
            }
        }
    }

    //
    //  mask ˤ̩ [/deg]
    //
    for(i = 0; i < num; i++) {
        index[i] = i;
        ind1 = stt[i];
        ind2 = end[i];
        ph1 = ph[ind1];
        ph2 = ph[ind2];
        if(ind1 > ind2) {
            ph1 -= 360;
            ind1 -= total;
        }
        if(ph2 > ph1) {
            dens[i] = (ind2 - ind1) / (ph2 - ph1);
        } else {
            dens[i] = 0;
        }
    }

    //
    // dens ͤǥ
    //
    index_sort(num, dens, index);

    //
    // ͤ
    //
    j = 0;
    region.ph_start = (double *) calloc(num, sizeof(double));
    region.ph_end = (double *) calloc(num, sizeof(double));
    region.density = (double *) calloc(num, sizeof(double));
    for(i = num - 1; i >= 0; i--) {
        ind1 = stt[index[i]];
        ind2 = end[index[i]];
        ph1 = ph[ind1];
        ph2 = ph[ind2];
        if(ind1 > ind2) {
            ph1 -= 360;
        }
        region.ph_start[j] = ph1;
        region.ph_end[j] = ph2;
        region.density[j] = dens[index[i]];
        j++;
    }

    region.num = num;

    free(stt);
    free(end);
    free(index);
    free(dens);

    return region;
    
}

/**
 *
 */
void create_mask(int num, double cut, int *start, int step, int total, 
                 double *diff, int *index, int *diff_mask, int *ph_mask)
{
    int i, j;
    int stt, end;

    for(i = num - 1; i >= 0; i--) {
        j = index[i];
        //printf("# %d/%d %d %d %lf %lf\n", i, num, step, diff_mask[j], diff[j], cut);
        if(diff[j] < cut) {
            break;
        }
        if(diff_mask[j] != 0) {
            continue;
        }

        stt = start[j];
        end = start[j] + step;
        if(end >= total) {
            end -= total;
        }
        //
        // diff  cut 礭礽Υץϥޥ (1) 롣
        //
        diff_mask[j] = 1;
        //printf("# do_mask_for_ph\n");
        do_mask_for_ph(total, ph_mask, stt, end, 1);
        //
        // stt - end ϰϤȽŤʤ륵ץϥޥ (2) 
        //
        //printf("# do_mask_overlap\n");
        do_mask_overlap(num, stt, end, step, total, start, diff_mask);

        //printf("# done [0]\n");
    }
    //printf("# done [1]\n");
}

/**
 * stt1 - end1 ϰϤȽŤʤ륵ץޥ (mask_value=2) 
 */
void do_mask_overlap(int num, int stt1, int end1, int step, int total, int *start, int *diff_mask) 
{
    int i;
    int stt2, end2;
    
    if(stt1 > end1) {
        stt1 -= total;
    }

    for(i = 0; i < num; i++) {
        if(diff_mask[i] != 0) {
            continue;
        }
        stt2 = start[i];
        end2 = start[i] + step;
        if(stt1 > end2) {
            stt2 -= total;
        }
        if(stt2 < end1 && stt2 >= stt1) {
            diff_mask[i] = 2;
        }
        if(end2 <= end1 && end2 > stt1) {
            diff_mask[i] = 2;
        }
    }
}


/**
 *
 */
void do_mask_for_ph(int total, int *ph_mask, int start, int end, int mask_value) 
{
    int i;

    //printf("# total=%d start=%d end=%d\n", total, start, end);

    for(i = start; i != end; i = (i + 1) % total) {
        //printf("# i=%d\n", i);
        if(ph_mask[i] != 0) {
            continue;
        }
        ph_mask[i] = mask_value;
    }
}


/**
 *  Ǥ˥ȺѤߤ ph[] κdiff = ph[i+1] - ph[i] ʿͤɸк롣
 *  diff ͤ diff_cut 礭ʥץϽƵ롣
 *
 *  return x[0] : ph κʿ
 *         x[1] : ph κɸк
 */
void cal_stat(int num, double *diff, double diff_cut, int *mask, double stat[2])
{
    int i, k;
    double s1, s2;
    double ave, sig;

    //
    //
    //
    k = 0;
    s1 = 0;
    s2 = 0;
    for(i = 0; i < num; i++) {
        if(diff[i] >= diff_cut) {
            continue;
        } else if(mask[i] == 1) {
            continue;
        } else {
            s1 += diff[i];
            s2 += (diff[i] * diff[i]);
            k++;
	}
    }

    //
    // ʿͤʬκƷ׻
    //
    if(k > 0) {
        ave = s1 / (double) k;
    } else {
        ave = 0;
    }
    if(k > 1) {
        sig =  (s2 - ave * ave * k) / (double) (k - 1);
        sig = sqrt(sig);
    } else {
        sig = 0;
    }
    //
    //
    //
    stat[0] = ave;
    stat[1] = sig;
}


/**
 *
 */
void output() 
{
    int i;
    double mask_area;
    double ds, density;
    double r0, r1, r2;

    //
    //
    //
    if(g_log == 1) {
        printf("# log\n");
        printf("# log_step = %lf\n", g_bin_logsize);
    } else if(g_rr == 1) {
        printf("# r2\n");
        printf("# r2_step = %lf\n", g_bin_r2size);
    } else {
        printf("# linear\n");
        printf("# r_step = %lf\n", g_bin_size);
    }

    //
    //
    //
    printf("# number r_middle earea    bad_fraction  number density   bin_from bin_to\n");
    printf("# ------ arcsec   arcmin2  ----          ---    arcmim-2  ---      ---\n");
    for(i = 0; i < N_TH; i++) {
        r0 = g_r0[i];
        r1 = g_r1[i];
        r2 = g_r2[i];
	//
	// 濴Υޥΰ
	//
	if(g_mask_rmax > r1) {
	    if(g_mask_rmax <= r2) {
		mask_area = PI * (g_mask_rmax * g_mask_rmax - r1 * r1);
	    } else {
		mask_area = PI * (r2 * r2 - r1 * r1);
	    }
	} else {
	    mask_area = 0;
	}
	//if(g_num[i] <= 0) {
        //g_dead_frac[i] = 0.0;
        //}
	ds = (PI * (r2 * r2 - r1 * r1) - mask_area)  * (1 - g_dead_frac[i]);
        density = 0;
        if(ds > 0) {
            density = g_num[i] / (ds/60./60.);
        }
	printf("%d %lf %le %lf %d %lf %d %d\n", i, r0, ds/60./60., 
               g_dead_frac[i],  g_num[i], density, g_from[i], g_to[i]);
               
    }
}



/**
 *
 */
void rotate(double mat[3][3],
	    double x, double y, double z,
	    double *x2, double *y2, double *z2)
{
    int i, j;
    double v[3], v2[3];

    v[0] = x;
    v[1] = y;
    v[2] = z;

    for(i = 0; i < 3; i++) {
	v2[i] = 0;
	for(j = 0; j < 3; j++) {
	    v2[i] += mat[i][j] * v[j];
	}
    }

    *x2 = v2[0];
    *y2 = v2[1];
    *z2 = v2[2];

}

	    
