#!/bin/bash
#

#
#
#
#
# ؿ include
# 

if [ -z ${JVO_TOOLS} ]; then
   echo "you must set JVO_TOOLS"
   exit 1
fi

. ${JVO_TOOLS}/share/vo2012b/clustering/function.sh

c__init_pfile

#
# եƤ齪λ
#
trap "clean0" EXIT
trap "clean1" INT TERM 

function clean0
{
   if [ "$g_help" == "1" ]; then
      exit 1
   fi

   local code=$?
   c__clean

   if [ "$g_clean" == "1" ]; then
      clean
   fi

   exit $code
}

function clean1
{
   local code=$?
   exit $code
}

function clean {
   if [ "$c_tdir" == $(pwd) ]; then
      return 0
   fi
}

#
#
#
function start
{
   #
   # ȥǥ쥯ȥ
   # եѥʤɤ꤬ǹԤΤǡ
   # ˥ؤν񤭽Ф򤷤ʤȡ
   #
   c__create_wdir

   #
   # ȥǥ쥯ȥذư
   #
   pushd $c_wdir >& /dev/null

   #
   # ץȳϥå
   #
   c__script_start "$argv"

   #
   # ơե˳Ͼ
   # 
   c__status_start 

   #
   # ϻե˵Ͽ
   #
   c__mark_start
}


#
#
#
function finalize
{
   #
   # ϻե˵Ͽ
   #
   c__mark_end

   #
   # ｪλơ
   # 
   c__status_end

   #
   # ץȽλå
   # 
   c__script_end

}

#
# UKIDSS ǡ򸡺
#
function search_ukidss
{
    #
    # SQL
    #
    cat > .tmp-ukidss.$$.sql <<EOF
SELECT  ID, SOURCE_ID, RA2000, DE2000, MAG_K, SURVEY, kppErrBits
FROM    ivo://jvo/ukidss:catalog_dr7 AS t
WHERE   REGION('CIRCLE @ra@ @dec@ @rad@')
        AND (mergedClass = 1 OR mergedClass = -3)
EOF

    cat .tmp-ukidss.$$.sql | \
        awk '{gsub("@ra@", ra); gsub("@dec@", dec); gsub("@rad@", rad); print $0}' \
        ra=$g_ra dec=$g_dec rad=$g_rad > ukidss.sql
    
    #
    # Search
    #
    if ! jc search -i ukidss.sql -o ukidss.xml > .tmp.$$.log 2>&1; then
       echo "*** error : ukidss data search failed."
       cat .tmp.$$.log | tee -a $c_log
       return 1
    fi
    if [ ! -e ukidss.xml ]; then
       echo "*** error : ukidss data search failed."
       return 1
    fi

    #
    # Select
    #
    if ! jc select -F\| -o ukidss.csv ukidss.xml > .tmp.$$.log 2>&1; then
       echo "*** error : votable select failed."
       cat .tmp.$$.log | tee -a $c_log
       return 1
    fi

    #
    # ̿Υå
    #
    cat ukidss.csv | grep -v "#" > .tmp.$$.dat
    local n=$(cat .tmp.$$.dat | wc -l)

    c__log F:$FUNCNAME $LINENO "number of data = $n"
    if [ "$n" -lt 0 ]; then
       c__log F:$FUNCNAME $LINENO "no data found for ukidss."      
       return 2
    fi

    if [ "$n" -lt 10 ]; then
       c__log F:$FUNCNAME $LINENO "number of data is too small."      
       return 2
    fi

    #
    # K.cat ɬפʥǡȴФ (id, ra, dec, mag_K, survey)
    #
    cat ukidss.csv | grep -v "^#" | awk -F\| '{if($5>0&&$7<=255) print $2,$3,$4,$5,$6}' > K.cat

    if [ ! -s K.cat ]; then
       c__log F:$FUNCNAME $LINENO "# K-band data not found"
       return 1
    fi

}

#
# AGN εΥͭ(Ωγ?)׻
#
function earea_ukidss
{
   n=$(cat ukidss.csv | grep -v "#" | wc -l)

   local step=${g_step_dr}
   local step_sec=$(echo "${step}/(${g_dr_100}/100.)" | bc -l)

   cat K.cat | grep -v "#" | awk '{print $2,$3}' > radec.dat

   local args="-r $g_ra -d $g_dec --size ${step_sec} --mask-rmax ${g_mask}"

   c__log F:$FUNCNAME $LINENO "# agn-catalog-coverage ${args} < radec.dat > earea-K.dat "

   agn-catalog-coverage ${args} < radec.dat > earea-K.dat
}

#
#
# ʬŪʥǡη»ʤå
#
# check_coverage <badfrac_max>
#
function check_coverage
{
   #
   #
   #
   local badfrac_max=$1
#  local r_2Mpc=$(echo "2.0/(${g_dr_100}/100.)" | bc -l)
   local r_2Mpc=$(cosmic-distance -z ${g_redshift} --length 2.0 | grep "separation angle" | awk '{print $4}')

   c__log F:$FUNCNAME $LINENO "badfrac_max=$badfrac_max"
   c__log F:$FUNCNAME $LINENO "g_dr_100=$badfrac_max"
   c__log F:$FUNCNAME $LINENO "r_2Mpc=$r_2Mpc"

   #
   # UKIDSS
   #
   /bin/rm -f coverage-K.dat
   local fn_in=
   for fn_in in earea-K.dat; do
      if [ ! -e "${fn_in}" ]; then
         continue
      fi

      local band=$(echo ${fn_in%.dat} | awk -F- '{print $2}')
      local fn_out=coverage-${band}.dat

      /bin/rm -f $fn_out

      if [ -s "$fn_in" ]; then
         bad=$(cat $fn_in | grep -v "#" | awk '{if($2<r_2Mpc) print $4}' r_2Mpc=${r_2Mpc} | sort -nr | head -1)
         status=$(echo $bad | awk '{if($1>=min) { print "NG" } else { print "OK" }}' min=$badfrac_max)

         c__log F:$FUNCNAME $LINENO "max bad fraction for r < 2Mpc ($band) : $bad"

         if [ "$status" == "NG" ]; then
            c__log F:$FUNCNAME $LINENO "${band} band coverage is not good."
            echo "NG" > $fn_out
         else
            echo "OK" > $fn_out
         fi

      else
         echo "NG" > $fn_out
      fi
   done
}


#
#
#
function cal_limit_mag
{
   cat K.cat | grep -v "#" | awk '{print $4}' > .mag.$$.dat

   if [ ! -s .mag.$$.dat ]; then
      c__log F:$FUNCNAME $LINENO "catalog empty : K.cat"
      return 1
   fi

   cat .mag.$$.dat | make-hist --xmin 10 --xmax 30 --step 0.1  > mag-hist.dat

   local mag_peak=$(sort -nr -k +6 mag-hist.dat | head -1 | awk '{print $2}')

   cat .mag.$$.dat | awk '{if($1>=peak) print $1}' peak=$mag_peak | sort -n > .tmp.$$.dat

   local ntot=$(cat .tmp.$$.dat | wc -l)
   local n10=$(echo $ntot | awk '{print int($1*0.1)}')
   local n60=$(echo $ntot | awk '{print int($1*0.6)}')
   local n80=$(echo $ntot | awk '{print int($1*0.8)}')

   local mag_10=$(sed -n ${n10},${n10}p .tmp.$$.dat)
   local mag_60=$(sed -n ${n60},${n60}p .tmp.$$.dat)
   local mag_80=$(sed -n ${n80},${n80}p .tmp.$$.dat)

   c__log F:$FUNCNAME $LINENO "mag_limit = $mag_60"

   echo $mag_peak $mag_10 $mag_60 $mag_80 > limit-mag.dat
}

#
#
#
function mk_hist
{
   #
   # ץ
   #
   local fn=
   local band=

   local stat=$(cat coverage-K.dat | tail -1)
   if [ "$stat" != "OK" ]; then
      c__log F:$FUNCNAME $LINENO "bad coverage: skip"
      return 1
   fi

   if [ ! -e earea-K.dat ]; then
      c__log F:$FUNCNAME $LINENO "earea file earea-K.dat does not exist"
      return 1
   fi

   #
   # ra,dec
   #
   cat K.cat | grep -v "#" | awk '{print $2,$3}' > radec.dat

   #
   #
   #
   local dth=$(cosmic-distance -z ${g_redshift} --length ${g_step_dr} | \
               grep "separation angle" | awk '{print $4}')
   local args="-r ${g_ra} -d ${g_dec} --dth ${dth} --earea earea-K.dat"
   args="${args} -c radec.dat --mask-rad 4.0 -z ${g_redshift}"
   c__log F:$FUNCNAME $LINENO "# agn-catalog-density $args"
   agn-catalog-density $args > hist.dat 2>&1
}

#
#
#
function graphic
{
   local rad1Mpc=$(cosmic-distance -z ${g_redshift} --length 1.0 | \
               grep "separation angle" | awk '{print $4/60/60}')
   cp ${g_share}/plot-dist.C .
   local macro="plot-dist.C(${g_ra},${g_dec},${g_rad},${rad1Mpc})"
   root -b -q ${macro}
   convert plot-dist.eps plot-dist.png
}

#
#
#
function summary 
{
   if [ ! -e Result ]; then
      mkdir Result
   fi

   local start=$(cat .start)
   local end=$(cat .end)
   local cmd=$(cat .command)

   echo "#" > summary.dat
   echo "#" >> summary.dat
   echo "#" >> summary.dat
   echo "START:   $start"  >> summary.dat
   echo "END:     $end"    >> summary.dat
   echo "COMMAND: $cmd"    >> summary.dat
   echo "#" >> summary.dat
   echo "#" >> summary.dat
   echo "#" >> summary.dat
   echo "NAME: $g_name"  >> summary.dat
   echo "RA: $g_ra" >> summary.dat
   echo "DEC: $g_dec" >> summary.dat
   echo "RADIUS: $g_rad" >> summary.dat
   echo "REDSHIFT: $g_redshift" >> summary.dat
   echo "BAND: K" >> summary.dat

   if [ -e limit-mag.dat ]; then
      local mag_peak=$(cat limit-mag.dat | awk '{print $1}')
      local mag_10=$(cat limit-mag.dat | awk '{print $2}')
      local mag_60=$(cat limit-mag.dat | awk '{print $3}')
      local mag_80=$(cat limit-mag.dat | awk '{print $4}')
      echo "MAG_PEAK: $mag_peak" >> summary.dat
      echo "MAG_10: $mag_10" >> summary.dat
      echo "MAG_60: $mag_60" >> summary.dat
      echo "MAG_80: $mag_80" >> summary.dat
   fi

   cp hist.dat Result
   cp summary.dat Result
   cp plot-dist.png Result
}



#
#
#
function skip_all
{
   g_skip_search=1
   g_skip_earea=1
   g_skip_hist=1
   g_skip_limit=1
   g_skip_graphic=1
   g_skip_summary=1
}

#
#
#
g_ra=
g_dec=
g_rad=
g_name=
g_redshift=

g_skip_search=0
g_skip_earea=0
g_skip_mkhist=0
g_skip_limit=0
g_skip_graphic=0
g_skip_summary=0

g_mask=4.0
g_clean=1
g_share=${JVO_TOOLS}/share/vo2012/clustering

if [ "$J_NOCLEAN" == "1" ]; then
   g_clean=0
fi

while [ $# -gt 0 ]; do

   case $1 in
   -h|--help)
      echo "Usage: ${0##/*/} -r <ra> -d <dec> --rad <rad> -z <redshift> [OPTIONS]"
      echo "Required Args are:"
      echo "   -r, --ra            RA (deg)"
      echo "   -d, --dec           Dec (deg)"
      echo "     , --rad           radius (deg)"
      echo "   -z, --redshift      redshift"
      echo "   -n, --name          name of the AGN"
      echo "   -m, --mask          mask region radius (arcsec)"
      echo "Options are:"
      echo "   -t, --tag           tag name"
      echo "   -w, --wdir          work direcotyr"
      echo "     , --no-clean      don't remove temp files"
      echo "     , --graphic       skip all other than creating graphic"
      echo "   -h, --help          shows this help"
      exit 1
      ;;

   -r|--ra)
      g_ra=$2
      shift 2
      ;;

   -d|--dec)
      g_dec=$2
      shift 2
      ;;

   --rad)
      g_rad=$2
      shift 2
      ;;

   -z|--redshift)
      g_redshift=$2
      shift 2
      ;;

   -n|--name)
      g_name=$2
      shift 2
      ;;

   -m|--mask)
      g_mask=$2
      shift 2
      ;;

   -w|--wdir)
      c_wdir=$2
      shift 2
      ;;

   --search)
      skip_all
      g_skip_search=0
      shift 1
      ;;

   --mk-hist)
      skip_all
      g_skip_mkhist=0
      shift 1
      ;;

   --graphic)
      skip_all
      g_skip_graphic=0
      shift 1
      ;;

   --no-clean)
      g_clean=0
      export J_NOCLEAN=1
      shift
      ;;

   *)
      echo "### warning : unkonwn option : $1" 
      shift
      ;;
   esac
done

#
# ѿ
#
g_step_dr=0.1 
g_dr_100=$(cosmic-distance -z ${g_redshift} -t 100  | grep "comoving separation distance" | awk '{print $5}')
g_dtag=test

if [ "$g_name" == "" ]; then
   sexag=$(echo $g_ra $g_dec |  deg2sexag.pl)
   ra_sexag=$(echo $sexag | awk '{gsub(":", "", $1); print $1}' | cut -b 1-9)
   dec_sexag=$(echo $sexag | awk '{gsub(":", "", $2); print $2}' | cut -b 1-9)
   g_name=J${ra_sexag}${dec_sexag}
fi



#
# ¹Գϻν
#
start

#
#
#
if [ "$g_skip_search" != 1 ]; then
   echo "# search UKIDSS"
   if ! search_ukidss; then
      skip_all
      g_skip_summary=0
   fi
fi

#
#
#
if [ "$g_skip_earea" != 1 ]; then
   echo "# effective area for ukidss"
   earea_ukidss

   echo "# check coverage"
   check_coverage 0.2 0.2
fi

#
#
#
if [ "$g_skip_hist" != 1 ]; then
   mk_hist
fi

#
#
#
if [ "$g_skip_limit" != 1 ]; then
   cal_limit_mag
fi

#
#
#
if [ "$g_skip_graphic" != 1 ]; then
   graphic
fi

#
# λ
#
finalize

#
#
#
if [ "$g_skip_summary" != 1 ]; then
   summary
fi

exit 0
