#!/bin/bash
#
# agn-dataset-ukidss.sh μ¹Է̤Ȥ
#
# ¹Է̥ǥ쥯ȥ˰ʲΥե뤬뤳ȡ
#
#    Result/summary.dat
#    Result/hist.dat
#


#
# ؿ include
# 

if [ -z ${JVO_TOOLS} ]; then
   echo "you must set JVO_TOOLS"
   exit 1
fi

. ${JVO_TOOLS}/share/vo2012b/clustering/function.sh

c__init_pfile

#
# եƤ齪λ
#
trap "clean0" EXIT
trap "clean1" INT TERM 

function clean0
{
   if [ "$g_help" == "1" ]; then
      exit 1
   fi

   local code=$?
   c__clean

   if [ "$g_clean" == "1" ]; then
      clean
   fi

   exit $code
}

function clean1
{
   local code=$?
   exit $code
}

function clean {
   if [ "$c_tdir" == $(pwd) ]; then
      return 0
   fi
}


#
#
#
function start
{
   #
   # ȥǥ쥯ȥ
   # եѥʤɤ꤬ǹԤΤǡ
   # ˥ؤν񤭽Ф򤷤ʤȡ
   #
   c__create_wdir

   #
   # ץȳϥå
   #
   c__script_start "$argv"

   #
   # ơե˳Ͼ
   # 
   c__status_start 

   #
   # ϻե˵Ͽ
   #
   c__mark_start
}

#
#
#
function finalize
{
   #
   # ϻե˵Ͽ
   #
   c__mark_end

   #
   # ｪλơ
   # 
   c__status_end

   #
   # ץȽλå
   # 
   c__script_end

}



#
#
#
function main
{
   local line=
   local dir=

   /bin/rm -f ${g_fnout}
   /bin/rm -f .dens.$$.dat

   while read line; do
      #
      #
      #
      if echo ${line} | grep "^#" >& /dev/null; then
         continue   
      fi
      #
      #
      dir=$(echo $line | awk '{print $1}')
      c__log F:$FUCNAME $LINENO "# $dir"
      #
      #
      #
      if ! check_coverage ${dir}; then
         c__log F:$FUNCNAME $LINENO "# bad coverage : skip"
         continue
      fi 

      #
      #
      #
      if ! add ${dir}; then
         c__log F:$FUNCNAME $LINENO "# chi2 cut : skip"
         continue
      fi

      #
      #
      #
      if ! cal_rho0 ${dir}; then
         c__log F:$FUNCNAME $LINENO "# failed cal_rho0 : skip"
         continue
      fi
#     cal_rho0 ${dir}

      let $(( g_count++ ))
   done < $g_fnlist

   cal_rho0_ave
}


#
#
# ʬŪʥǡη»ʤå
#
# check_coverage <badfrac_max>
#
function check_coverage
{
   #
   #
   #
   local dir=$1
   local badfrac_max=0.2
   local r_2Mpc=$(cosmic-distance -z ${g_redshift} --length 2.0 | grep "separation angle" | awk '{print $4}')

#  c__log F:$FUNCNAME $LINENO "badfrac_max=$badfrac_max"
#  c__log F:$FUNCNAME $LINENO "g_dr_100=$badfrac_max"
#  c__log F:$FUNCNAME $LINENO "r_2Mpc=$r_2Mpc"

   #
   # UKIDSS
   #
   local fn_in=${dir}/earea-K.dat
   if [ ! -e "${fn_in}" ]; then
      fn_in=${dir}/earea.dat
      if [ ! -e "${fn_in}" ]; then
         c__log F:$FUNCNAME $LINENO "earea.dat does not exist"
         return 1
      fi
   fi

   if [ -s "$fn_in" ]; then
      local bad=$(cat $fn_in | grep -v "#" | awk '{if($2<r_2Mpc) print $4}' r_2Mpc=${r_2Mpc} | \
                  sort -nr | head -1)
      local status=$(echo $bad | awk '{if($1>=min) { print "NG" } else { print "OK" }}' min=$badfrac_max)
      if [ "$status" == "NG" ]; then
         c__log F:$FUNCNAME $LINENO "max bad fraction for r < 2Mpc ($band) : $bad"
         c__log F:$FUNCNAME $LINENO "${band} band coverage is not good."
         return 1
      else
         return 0
      fi
   else
      c__log F:$FUNCNAME $LINENO "earea.dat is empty"
      return 1
   fi
}




#
#
#
function cal_rho0_ave
{
#  echo "# average density"
#  echo "# sum ave num"

   stat1=$(cat .dens.$$.dat | awk '{S=S+$2;N=N+1;print S,S/N,N}' | tail -1)
   stat2=$(cat .dens.$$.dat | awk '{S=S+$3;N=N+1;print S,S/N,N}' | tail -1)
   stat3=$(cat .dens.$$.dat | awk '{S=S+$4;N=N+1;print S,S/N,N}' | tail -1)
   stat4=$(cat .dens.$$.dat | awk '{S=S+$5;N=N+1;print S,S/N,N}' | tail -1)

   cp .dens.$$.dat density.dat

   echo "# average density" >> ${g_fnout}
   echo "# sum ave num" >>  ${g_fnout}
   echo "# AVE_DEN_PK: $stat1" >> ${g_fnout}
   echo "# AVE_DEN_10: $stat2" >> ${g_fnout}
   echo "# AVE_DEN_60: $stat3" >> ${g_fnout}
   echo "# AVE_DEN_80: $stat4" >> ${g_fnout}

}

#
#
#
function cal_rho0
{
#  echo "# cal_rho0"

   local dir=$1
   local fn_summ=${dir}/Result/summary.dat
   local fn_hist=${dir}/mag-hist.dat

   if [ ! -e ${fn_summ} ]; then

      /bin/rm -f $fn_hist

      fn_summ=${dir}/summary.dat
      if [ ! -e ${fn_summ} ]; then
         echo "# $fn_summ does not exist"
         return 1
      fi
   fi


   local limit_peak=
   local limit_10=
   local limit_60=
   local limit_80=

   if [ ! -e ${fn_hist} ]; then
#     echo "# create $fn_hist"
      cat ${dir}/radecmag.dat | awk '{print $3}' > .mag.$$.dat
      cat .mag.$$.dat | make-hist --xmin 10 --xmax 30 --step 0.1 > ${fn_hist}
      limit_peak=$(sort -nr -k +6 ${fn_hist} | head -1 | awk '{print $2}')
      cat .mag.$$.dat | awk '{if($1>=peak) print $1}' peak=$limit_peak | sort -n > .tmp.$$.dat

      local ntot=$(cat .tmp.$$.dat | wc -l)
      if [ "${ntot}" -le 20 ]; then
         c__log F:$FUNCNAME $LINENO "number of mag bins above mag peak is too low"
         return 1
      fi

      local n10=$(echo $ntot | awk '{print int($1*0.1)}')
      local n60=$(echo $ntot | awk '{print int($1*0.6)}')
      local n80=$(echo $ntot | awk '{print int($1*0.8)}')

#     echo "# ntot=$ntot n10=$n10 n60=$n60 n80=$n80"

      limit_10=$(sed -n ${n10},${n10}p .tmp.$$.dat)
      limit_60=$(sed -n ${n60},${n60}p .tmp.$$.dat)
      limit_80=$(sed -n ${n80},${n80}p .tmp.$$.dat)
      /bin/rm -f .mag.$$.dat .tmp.$$.dat
   fi

   #
   #
   #
   local redshift=$(cat $fn_summ | grep "^REDSHIFT:" | awk '{print $2}')
   local band=$(cat $fn_summ | grep "^BAND:" | awk '{print $2}')
   local nsum=$(cat ${fn_hist} | awk '{S=S+$6; print S}' | tail -1)
   local nth=$(echo $nsum | awk '{print int($1*0.05)+1}')
   local mmin=$(cat ${fn_hist} | awk '{S=S+$6; if(S>nth&&$6>0) {print $2}}' nth=$nth | head -1)

   if [ "${nsum}" -le 20 ]; then
      c__log F:$FUNCNAME $LINENO "number of object is too low: $nsum"
      return 1
   fi

#   echo "# redshift=$redshift band=$band nsum=$nsum nth=$nth mmin=$mmin"

   if [ "$limit_60" == "" ]; then
      limit_peak=$(cat $fn_summ | grep "^MAG_PEAK:" | awk '{print $2}')
      limit_10=$(cat $fn_summ | grep "^MAG_10:" | awk '{print $2}')
      limit_60=$(cat $fn_summ | grep "^MAG_60:" | awk '{print $2}')
      limit_80=$(cat $fn_summ | grep "^MAG_80:" | awk '{print $2}')
   fi

   if [ "$limit_10" == "" ] || [ "$limit_60" == "" ] || [ "$limit_80" == "" ]; then
      c__log F:$FUNCNAME $LINENO "invalid limit_mag = {$limit_peak,$limit_10,$limit_60,$limit_80}"
      return 1
   fi

   if [ "$band" == "K" ]; then
      limit_peak=$(echo "${limit_peak}+1.85" | bc -l) # Vega2AB
      limit_10=$(echo "${limit_10}+1.85" | bc -l) # Vega2AB
      limit_60=$(echo "${limit_60}+1.85" | bc -l) # Vega2AB
      limit_80=$(echo "${limit_80}+1.85" | bc -l) # Vega2AB
      mmin=$(echo "${mmin}+1.85" | bc -l) # Vega2AB
   fi

   local opt="-z $redshift -b $band --m-min $mmin"

#   echo "# opt=$opt"
#   echo "# mmin= $mmin"
#   echo "# limit= {$limit_peak,$limit_10,$limit_60,$limit_80}"

   local den_peak=$(agn-cal-rho0 -m $limit_peak $opt | grep -v "#" | grep "rho=" | awk '{print $2}')
   local den_10=$(agn-cal-rho0 -m $limit_10 $opt | grep -v "#" | grep "rho=" | awk '{print $2}')
   local den_60=$(agn-cal-rho0 -m $limit_60 $opt | grep -v "#" | grep "rho=" | awk '{print $2}')
   local den_80=$(agn-cal-rho0 -m $limit_80 $opt | grep -v "#" | grep "rho=" | awk '{print $2}')

   echo $band $den_peak $den_10 $den_60 $den_80 $limit_peak $limit_10 $limit_60 $limit_80 $redshift >> .dens.$$.dat
}


#
# add <dir>
#
function add
{
   local dir=$1
   local fn_summ=${dir}/Result/summary.dat
   if [ ! -e ${fn_summ} ]; then
      fn_summ=${dir}/summary.dat
      if [ ! -e ${fn_summ} ]; then
         echo "# $fn_summ does not exist"
         return 1
      fi
   fi

   #
   # AGN ̾ redshift
   #
   local qso=$(cat $fn_summ | grep "^NAME:" | awk '{print $2}')
   local redshift=$(cat $fn_summ | grep "^REDSHIFT:" | awk '{print $2}')
   if [ "$qso" == "" ]; then
      local ra=$(cat $fn_summ | grep "^RA:" | awk '{print $2}')
      local dec=$(cat $fn_summ | grep "^DEC:" | awk '{print $2}')
      sexag=$(echo $ra $dec |  deg2sexag.pl)
      ra_sexag=$(echo $sexag | awk '{gsub(":", "", $1); print $1}' | cut -b 1-9)
      dec_sexag=$(echo $sexag | awk '{gsub(":", "", $2); print $2}' | cut -b 1-9)
      qso=J${ra_sexag}${dec_sexag}
   fi

   #
   # ҥȥब뤫
   #
   local fn_hist=${dir}/Result/hist.dat
   if [ ! -s ${fn_hist} ]; then
      fn_hist=${dir}/hist.dat
      if [ ! -s ${fn_hist} ]; then
         echo "# histogram not found for ${qso}"
         return 1
      fi
   fi

   #
   # CHI2 & DEV cut
   #
   cat ${fn_hist} | grep -v "^#" | awk '{print $1,$5,$6}' | agn-check-uniform $opt > .tmp.$$.dat
   local chi2=$(cat .tmp.$$.dat | grep CHI2: | awk '{print $3/$5}')
   local dev=$(cat .tmp.$$.dat | grep -v "#" | grep DEV: | \
      awk '{if($4>=0) {print $4} else {print -$4}}' | sort -nr | head -1)
   local stat=
   stat=$(echo $chi2 | awk '{if($1>=max) {print "1"} else {print "0"}}' max=$g_chi2_max)
   if [ "$stat" == "1" ]; then
      c__log F:$FUNCNAME $LINENO "chi2 cut: $qso ($chi2)"
      return 1
   fi
   stat=$(echo $dev |  awk '{if($1>=max || $1<=-max) {print "1"} else {print "0"}}' max=$g_dev_max)
   if [ "$stat" == "1" ]; then
      c__log F:$FUNCNAME $LINENO "deviation cut: $qso ($dev)"
      return 1
   fi

   #
   # fn_out  AGN ­
   #
   if [ ! -e $g_fnout ]; then
      echo "# NUMBER_AGN: $g_count" >  $g_fnout
      echo "# AGN_STAT: $qso $chi2 $dev ${dir}" >> $g_fnout
      cat $fn_hist | grep -v "#" >> $g_fnout

   else
      cat $g_fnout | grep -v "#" > .tmp0.$$.dat
      cat $fn_hist | grep -v "#" > .tmp1.$$.dat
      cp .tmp0.$$.dat tmp0.dat
      cp .tmp1.$$.dat tmp1.dat
      cat $g_fnout | grep "# AGN_STAT:" > .qso.$$.dat
      #
      #               $9  $10 $11 $12  $13  $14   $15   $16
      # tmp1.$$.dat : <n> <r> <N> <N0> <S> <N0/S> <ERR>  <BAD>
      #
      paste .tmp0.$$.dat .tmp1.$$.dat | awk '{if(NF==16) print $0}' | \
            awk '{
              if ($11>0) {
                 COR=$12/$11;
              } else {
                 COR=1;
              }

              S0=$3+$11;
              S1=$4+$12;
              S2=$5+$13;

              if($13>0) {
                 DEN0=$12/$13;
                 ER2=$11*COR*COR/($13*$13);
              } else {
                 DEN0=0
                 ER2=0
              }

              DEN=($6*(N-1)+DEN0)/N;
              ERR=sqrt($7*$7*(N-1)*(N-1)+ER2)/N;
              BAD=($8*(N-1)+$16)/N;

              printf("%d %f %d %f %f %f %f %f\n", $1, $2, S0, S1, S2, DEN, ERR, BAD);
            }' N=${g_count} > .tmp.$$.dat

      cp .tmp.$$.dat tmp.dat
      if [ ! -s tmp.dat ]; then
         exit 0
      fi
      echo "# NUMBER_AGN: $g_count" > $g_fnout
      cat .qso.$$.dat >> $g_fnout
      echo "# AGN_STAT: $qso $chi2 $dev ${dir}" >> $g_fnout
      cat .tmp.$$.dat >> $g_fnout

#     exit 0
   fi
}

#
#
#
g_fnlist=
g_chi2_cut=0
g_chi2_max=3
g_dev_max=5
g_fg_rmin=0.1
g_fg_rmax=1.0
g_bg_rmin=2.0
g_bg_rmax=2.8
g_binning=1x60
g_tag=test
g_fnout=hist_add.dat
#
#
#
while [ $# -gt 0 ]; do
   case $1 in

   -l|--list)
      g_fnlist=$2
      shift 2
      ;;

   --chi2-cut)
      g_chi2_cut=1
      shift 1
      ;;

   --chi2-max)
      g_chi2_max=$2
      shift 2
      ;;

   --dev-max)
      g_dev_max=$2
      shift 2
      ;;

   --fg-rmin)
      g_fg_rmin=$2
      shift 2
      ;;

   --fg-rmax)
      g_fg_rmax=$2
      shift 2
      ;;

   --bg-rmin)
      g_bg_rmin=$2
      shift 2
      ;;

   --bg-rmax)
      g_bg_rmax=$2
      shift 2
      ;;

   --binning)
      g_binning=$2
      shift 2
      ;;

   --tag)
      g_tag=$2
      shift 2
      ;;

   -h|--help|*)
      echo "Usage: hist-add.sh [OPTIONS]"
      echo "Options are:"
#
#     echo "   , --zmin         lower redshift (default=$def1)"
#     echo "   , --zmax         higher redshift (default=$def2)"
#     echo "   , --abs-min      lower absolute mag (default=$def3)"
#     echo "   , --abs-max      higher absolute mag (default=$def4)"
#
      echo " -l, --list         list of data directory"
#     echo "   , --chi2-cut     chi2 cut"
      echo "   , --chi2-max     max chi2"
      echo "   , --dev-max      max deviation in sigma"

      echo "   , --fg-rmin      foreground region: lower bound [Mpc]"
      echo "   , --fg-rmax      foreground region: upper bound [Mpc]"
      echo "   , --bg-rmin      background region: lower bound [Mpc]"
      echo "   , --bg-rmax      background region: upper bound [Mpc]"

      echo "   , --binning      binning (e.g. 1x60 -1x1,2x29)"
#
      echo "   , --tag          result histogram tag (default=<zmin>_<zmax>_<absmin>_<absmax>)"
      echo "   , --skip-list    skip create_list"
      echo "   , --skip-add     skip hist-add-simple.sh"
      echo "   , --skip-density skip average density calculation"
      echo " -h, --help         show this help"
      exit 1
      ;;
   esac
done

#
#
#
g_count=1
g_line=
g_dir=

c_wdir=.

start

main

finalize

exit 0
