#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "opt.h"

int nbuff = 1000;
double width = 1.0;
double min = -1e20;
double max =  1e20;

int main(int argc, char *argv[]) {

    double x;
    double *buff;
    double diff;

    double density;
    double density_max = -1;
    double mode;
	
    long ind = 0;
    long ind_low = 0;
    long ind_upp = 0;
    
    optUsage("cal-mode: <input sorted data from stdin>");

    optrega(&width, OPT_DOUBLE, 'w', "width", "width to calculate local density");
    optrega(&nbuff, OPT_INT, 'n', "nbuff", "size of buffer array");
    optrega(&min, OPT_DOUBLE, '\0', "min", "minimum value");
    optrega(&max, OPT_DOUBLE, '\0', "max", "maximum value");

    opt(&argc, &argv);

    buff = (double *) malloc(sizeof(double) * nbuff);
    
    while(1) {
	if(feof(stdin) == 1) {
	    break;
	}

	fscanf(stdin, "%lf", &x);

	//
	//
	//
	if(x < min || x > max) {
	    continue;
	}

	ind = ind_upp % nbuff;
	buff[ind] = x;

	while((diff = buff[ind] - buff[ind_low % nbuff]) > width) {
	    ind_low++;
	    if(ind_low >= ind_upp) {
		break;
	    }
	}

	//
	// ind_low, ind_upp 
	//
	ind = ((ind_upp + ind_low) / 2) % nbuff;
        mode = 0;
	if(diff > width * 0.5 && diff <= width) {
	    density = (ind_upp - ind_low) / diff;

	    if(density >= density_max) {
		density_max = density;
		mode = buff[ind];
	    }
	       
	    printf("%lf %lf %lf %lf %lf  %ld %ld\n",
		   buff[ind], (ind_upp - ind_low) / diff, diff,
		   mode, density_max, ind_low, ind_upp);
	}
	ind_upp++;
    }

    exit(0);
}
