#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "opt.h"
#include "qsort2.h"

float g_clipsigma=3.0;

double g_ave0=-1e20;
double g_sig0=-1e20;

void set_opt(int argc, char *argv[]);
void cal_stat();

/**
 *
 */
int main(int argc, char *argv[]) {
    //
    //
    //
    set_opt(argc, argv);

    //
    //
    //
    cal_stat();

    exit(0);
}

/**
 *
 */
void set_opt(int argc, char *argv[]) 
{
    optUsage("[OPTIONS]\n");
    //optAdditionalUsage("cal-stat calculates statistic parameter for standard input\n");

    optrega(&g_clipsigma, OPT_FLOAT,  '\0', "clip-sigma", "clip sigma (defualt=3.0)" );
    optrega(&g_ave0, OPT_DOUBLE,  '\0', "ave0", "approximate average value" );
    optrega(&g_sig0, OPT_DOUBLE,  '\0', "sig0", "approximate sigma value" );

    opt(&argc, &argv);
}


/**
 *
 */
void cal_stat()
{
    int i;
    int ind50, ind16, ind84;
    int count, count2;
    int step = 100000;
    double *x, *x2;
    int *mask;
    double s1, s2, ave, sig, sig2, med, low68, upp68;

    x = (double *) calloc(step, sizeof(double));
    mask = (int *) calloc(step, sizeof(int));
    i = 0;
    while(feof(stdin) == 0) {
        fscanf(stdin, "%lf", &x[i]);
	//printf("%d %lf\n",i, x[i]);
	if(feof(stdin) != 0) {
	    break;
	}
	mask[i] = 0;
        i++;
        if((i % step) == 0) {
            x = (double *) realloc(x, (i + step) * sizeof(double));
            mask = (int *) realloc(mask, (i + step) * sizeof(int));
        }
    }
    count = i;
    
    //printf("# koko 1\n");

    //
    // step 0 : sigma clip by  g_ave0
    //
    if(g_ave0 > -1e19 && g_sig0 > -1e19) {
        for(i = 0; i < count; i++) {
            sig2 = (x[i] - g_ave0) / g_sig0;
            if(fabs(sig2) > g_clipsigma) {
                mask[i] = 1;
            } else {
                mask[i] = 0;
            }
        }
    }

    ///printf("# koko 2\n");

    //
    // step 1 : ʿ͡ɸк  
    //
    s1 = s2 = 0;
    count2 = 0;
    for(i = 0; i < count; i++) {
        if(mask[i] == 1) {
            continue;
        }
        s1 += x[i];
        s2 += x[i] * x[i];
        count2++;
    }

    if(count2 > 2) {
        ave = s1 / (double) count2;
        sig = (s2 - ave * ave * count2) / (double) (count2 - 1);
        if(sig > 0) {
            sig = sqrt(sig);
        } else {
            sig = 0;
        }
    } else if(count2 == 1) {
        ave = s1;
        sig = 0;
    } else {
        ave = 0;
        sig = 0;
    }

    //printf("# koko 3\n");
    //
    // step 2 : sigma clip
    //
    s1 = s2 = 0;
    count2 = 0;
    x2 = (double *) calloc(count, sizeof(double));
    for(i = 0; i < count; i++) {
        if(mask[i] == 1) {
            continue;
        }
        if(sig > 0) {
            sig2 = (x[i] - ave) / sig;
            if(fabs(sig2) > g_clipsigma) {
                mask[i] = 2;
                continue;
            }
        }
        x2[count2] = x[i];
        s1 += x[i];
        s2 += x[i] * x[i];
        count2++;
    }

    //printf("# koko 4\n");

    //
    // ׻
    //
    if(count2 >= 2) {
        ave = s1 / (double) count2;
        sig = (s2 - ave * ave * count2) / (double) (count2 - 1);
        if(sig > 0) {
            sig = sqrt(sig);
        } else {
            sig = 0;
        }
    } else if(count2 == 1) {
        ave = s1;
        sig = 0;
    } else {
        ave = 0;
        sig = 0;
    }

    if(count2 > 0) {
        qsort2(count2, x2);
        ind50 = (int) (count2 * 0.50);
        ind16 = (int) (count2 * 0.16);
        ind84 = (int) (count2 * 0.84);
        med = x2[ind50];
        low68 = x2[ind16];
        upp68 = x2[ind84];
    } else {
        med = 0;
        low68 = 0;
        upp68 = 0;
    }
    
    //printf("# koko 5\n");

    //
    // 
    //
    printf("total      %20d  # total number of samples\n", count);
    printf("num        %20d  # number of samples after sigma clip\n", count2);
    printf("sigma_clip %20f  # sigma for clip\n", g_clipsigma);
    printf("average    %20lf  # average after sigma clip\n", ave);
    printf("sigma      %20lf  # standard deviation after sigma clip\n", sig);

    printf("median     %20lf  # median after sigma clip\n", med);
    printf("low68      %20lf  # 1 sigma upper bound\n", low68);
    printf("upp68      %20lf  # 1 sigma lower bound\n", upp68);
}
