#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <stdlib.h>

#include "opt.h"

double xmin;
double xmax;
double step;

int main(int argc, char *argv[]) {
    int i;
    double x, x1, x2;
    int ind, nbin;
    int *hist;

    optUsage("");
    optrega(&xmin, OPT_DOUBLE, '\0', "xmin", "xmin");
    optrega(&xmax, OPT_DOUBLE, '\0', "xmax", "xmax");
    optrega(&step, OPT_DOUBLE, '\0', "step", "step");
    
    opt(&argc, &argv);

    nbin = (int) ((xmax - xmin) / step) + 1;
    hist = (int *) calloc(nbin, sizeof(int));
    
    while(1) {
        scanf("%lf", &x);
        if(feof(stdin)) break;
        if(x < xmin || x >= xmax) continue;
        ind = (int) ((x - xmin) / step);
        hist[ind]++;
    }
    
    for(i = 0; i < nbin; i++) {
        x1 = i * step + xmin;
        x2 = (i + 1) * step + xmin;
        printf("[ %lf - %lf ) %d\n", x1, x2, hist[i]);
    }

    exit(0);
}
