#!/usr/bin/perl

sub ra2deg($);
sub dec2deg($);

if(@ARGV > 0) {
    if($ARGV[0] eq "-h" || $ARGV[0] eq "--help")  {
	printf("Usage sexag2deg.pl 12:34:34.0 +23:23:23.0\n");
	printf("      or sexag2deg.pl < <file>\n");
	exit(1);
    }
}



if(@ARGV == 2) {
   $ra = ra2deg($ARGV[0]);
   $dec = dec2deg($ARGV[1]);
   printf("%lf %lf\n", $ra, $dec);
   exit(0);
}

while(<STDIN>) {
    @l = split('\s', $_);
    if(@l != 2) {next}
    $ra = ra2deg($l[0]);
    $dec = dec2deg($l[1]);
    printf("%lf %lf\n", $ra, $dec);
}


exit(0);


sub ra2deg($) {
    my $ra_sexag = $_[0];
    my @l, $h, $m, $s, $deg;

    if ($ra_sexag =~ /:/) {
	@l = split(':', $ra_sexag);
	$h = $l[0];
	$m = $l[1];
	$s = $l[2];
    } elsif ($ra_sexag =~ /^(\d\d)(\d\d)(\d\d.*)/) {
	$h = $1;
	$m = $2;
	$s = $3;
    }

    $deg = ($h  + ($m + $s / 60.) / 60.) / 24. * 360;
    
    return $deg;
}

sub dec2deg($) {
    my $dec_sexag = $_[0];
    my @l, $d, $m, $s, $deg;

    if ($dec_sexag =~ /:/) {
	@l = split(':', $dec_sexag);
	$d = $l[0];
	$m = $l[1];
	$s = $l[2];
    } elsif ($dec_sexag =~ /^(.\d\d)(\d\d)(\d\d.*)/) {
	$d = $1;
	$m = $2;
	$s = $3;
    }

    $deg = (abs($d)  + ($m + $s / 60.) / 60.);
    if($d =~ /^-/)  {$deg = -$deg;}

    return $deg;
}


exit(0);
